/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.transactions.payment;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Collection;
import org.egov.infra.utils.JsonUtils;
import org.egov.tl.entity.License;
import org.egov.tl.entity.contracts.OnlineSearchForm;
import org.egov.tl.service.TradeLicenseService;
import org.egov.tl.service.integration.LicenseBillService;
import org.egov.tl.web.response.adaptor.OnlineSearchTradeResultHelperAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/pay/online"})
public class LicenseBillOnlinePaymentController {
    @Autowired
    private LicenseBillService licenseBillService;
    @Autowired
    private TradeLicenseService tradeLicenseService;

    @ModelAttribute(value="onlineSearchForm")
    public OnlineSearchForm onlineSearchForm() {
        return new OnlineSearchForm();
    }

    @GetMapping(value={"{id}"})
    public String showPaymentForm(@PathVariable Long id, Model model) throws IOException {
        License license = this.tradeLicenseService.getLicenseById(id);
        if (license.isPaid()) {
            model.addAttribute("paymentdone", (Object)"License Fee already collected");
            return "license-onlinepayment";
        }
        model.addAttribute("collectXML", (Object)URLEncoder.encode(this.licenseBillService.createLicenseBillXML(license), "UTF-8"));
        return "license-onlinepayment";
    }

    @GetMapping
    public String searchForPayment() {
        return "searchtrade-licenseforpay";
    }

    @PostMapping(produces={"text/plain"})
    @ResponseBody
    public String searchLicense(OnlineSearchForm searchForm) {
        return "{ \"data\":" + JsonUtils.toJSON((Collection)this.tradeLicenseService.onlineSearchTradeLicense(searchForm), OnlineSearchForm.class, OnlineSearchTradeResultHelperAdaptor.class) + "}";
    }
}

