/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.transactions.legacy;

import java.io.IOException;
import javax.validation.Valid;
import org.egov.tl.entity.TradeLicense;
import org.egov.tl.web.controller.transactions.legacy.LegacyLicenseController;
import org.egov.tl.web.controller.transactions.legacy.LegacyLicenseValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/legacylicense"})
public class ModifyLegacyLicenseController
extends LegacyLicenseController {
    private static final String UPDATE_LEGACY_FORM = "updateform-legacylicense";
    @Autowired
    private LegacyLicenseValidator legacyLicenseValidator;

    @ModelAttribute(value="tradeLicense")
    public TradeLicense tradeLicense(@PathVariable Long id) {
        return (TradeLicense)this.tradeLicenseService.getLicenseById(id);
    }

    @GetMapping(value={"/update/{id}"})
    public String update(@ModelAttribute TradeLicense tradeLicense, Model model) {
        model.addAttribute("legacyInstallmentwiseFees", (Object)this.legacyService.legacyInstallmentwiseFees(tradeLicense));
        model.addAttribute("legacyFeePayStatus", (Object)this.legacyService.legacyFeePayStatus(tradeLicense));
        return UPDATE_LEGACY_FORM;
    }

    @PostMapping(value={"/update/{id}"})
    public String update(@Valid @ModelAttribute TradeLicense tradeLicense, BindingResult binding, Model model) throws IOException {
        this.legacyLicenseValidator.validate((Object)tradeLicense, (Errors)binding);
        if (binding.hasErrors()) {
            model.addAttribute("legacyInstallmentwiseFees", (Object)this.legacyService.legacyInstallmentfee(tradeLicense));
            model.addAttribute("legacyFeePayStatus", (Object)this.legacyService.legacyInstallmentStatus(tradeLicense));
            return UPDATE_LEGACY_FORM;
        }
        this.legacyService.updateLegacy(tradeLicense);
        return "redirect:/legacylicense/view/" + tradeLicense.getApplicationNumber();
    }
}

