/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.transactions.legacy;

import org.egov.tl.entity.License;
import org.egov.tl.entity.LicenseDocument;
import org.egov.tl.entity.TradeLicense;
import org.egov.tl.service.ValidityService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

@Component
public class LegacyLicenseValidator
implements Validator {
    @Autowired
    private ValidityService validityService;

    public boolean supports(Class<?> clazz) {
        return TradeLicense.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        TradeLicense license = (TradeLicense)target;
        if (!license.getDocuments().isEmpty()) {
            for (int index = 0; index < license.getFiles().length; ++index) {
                if (!((LicenseDocument)license.getDocuments().get(index)).getType().isMandatory() || !license.getFiles()[index].getOriginalFilename().isEmpty()) continue;
                errors.rejectValue("documents[" + index + "].description", "TL-011");
            }
        }
        if (this.validityService.getApplicableLicenseValidity((License)license) == null) {
            errors.rejectValue("category", "validate.license.validity");
        }
        if (license.getTradeArea_weight().intValue() < 1) {
            errors.rejectValue("tradeArea_weight", "validate.fee.range");
        }
        if (license.getCurrentState() != null) {
            errors.rejectValue("id", "validate.legacy.license.modify", new Object[]{license.getLicenseAppType().getName()}, "");
        }
    }
}

