/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.transactions.legacy;

import java.util.List;
import java.util.Map;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.tl.entity.LicenseCategory;
import org.egov.tl.entity.LicenseDocumentType;
import org.egov.tl.entity.NatureOfBusiness;
import org.egov.tl.entity.enums.ApplicationType;
import org.egov.tl.repository.LicenseRepository;
import org.egov.tl.service.FeeTypeService;
import org.egov.tl.service.LegacyLicenseService;
import org.egov.tl.service.LicenseCategoryService;
import org.egov.tl.service.TradeLicenseService;
import org.egov.tl.utils.Constants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;

@Controller
public class LegacyLicenseController
extends GenericWorkFlowController {
    @Autowired
    protected TradeLicenseService tradeLicenseService;
    @Autowired
    protected FeeTypeService feeTypeService;
    @Autowired
    protected BoundaryService boundaryService;
    @Autowired
    protected LicenseCategoryService licenseCategoryService;
    @Autowired
    protected LicenseRepository licenseRepository;
    @Autowired
    protected LegacyLicenseService legacyService;

    @ModelAttribute(value="boundary")
    public List<Boundary> boundaries() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("locality", "LOCATION");
    }

    @ModelAttribute(value="ownershipType")
    public Map<String, String> ownership() {
        return Constants.getOwnershipTypes();
    }

    @ModelAttribute(value="natureOfBusiness")
    public List<NatureOfBusiness> natureOfBusiness() {
        return this.tradeLicenseService.getAllNatureOfBusinesses();
    }

    @ModelAttribute(value="category")
    public List<LicenseCategory> category() {
        return this.licenseCategoryService.getCategories();
    }

    @ModelAttribute(value="documentTypes")
    public List<LicenseDocumentType> documentsList() {
        return this.tradeLicenseService.getDocumentTypesByApplicationType(ApplicationType.NEW);
    }

    @ModelAttribute(value="feeTypeId")
    public Long feeType() {
        return this.feeTypeService.findByName("License Fee").getId();
    }
}

