/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.transactions.legacy;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import javax.validation.Valid;
import org.egov.tl.entity.TradeLicense;
import org.egov.tl.service.LicenseAppTypeService;
import org.egov.tl.web.controller.transactions.legacy.LegacyLicenseController;
import org.egov.tl.web.controller.transactions.legacy.LegacyLicenseValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/legacylicense"})
public class CreateLegacyLicenseController
extends LegacyLicenseController {
    private static final String CREATE_LEGACY_LICENSE = "create-legacylicense";
    @Autowired
    private LegacyLicenseValidator legacyLicenseValidator;
    @Autowired
    private LicenseAppTypeService licenseAppTypeService;

    @ModelAttribute(value="tradeLicense")
    public TradeLicense tradeLicense() {
        TradeLicense license = new TradeLicense();
        license.setLicenseAppType(this.licenseAppTypeService.getLicenseAppTypeByName("New"));
        license.setApplicationDate(new Date());
        license.setApplicationNumber("AC-123");
        return license;
    }

    @ModelAttribute(value="legacyFeePayStatus")
    public Map<Integer, Boolean> legacyFeePayStatus() {
        return this.legacyService.legacyFeePayStatusForCreate();
    }

    @ModelAttribute(value="legacyInstallmentwiseFees")
    public Map<Integer, Integer> legacyInstallmentwiseFees() {
        return this.legacyService.legacyInstallmentwiseFeesForCreate();
    }

    @GetMapping(value={"/create"})
    public String create() {
        return CREATE_LEGACY_LICENSE;
    }

    @PostMapping(value={"/create"})
    public String create(@Valid @ModelAttribute TradeLicense tradeLicense, BindingResult binding, Model model) throws IOException {
        this.legacyLicenseValidator.validate((Object)tradeLicense, (Errors)binding);
        if (binding.hasErrors()) {
            model.addAttribute("legacyInstallmentwiseFees", (Object)this.legacyService.legacyInstallmentfee(tradeLicense));
            model.addAttribute("legacyFeePayStatus", (Object)this.legacyService.legacyFeeStatus(tradeLicense));
            return CREATE_LEGACY_LICENSE;
        }
        this.legacyService.createLegacy(tradeLicense);
        return "redirect:/legacylicense/view/" + tradeLicense.getApplicationNumber();
    }

    @GetMapping(value={"/old-licenseno-is-unique"}, produces={"application/json"})
    @ResponseBody
    public Boolean checkOldLicenseNumber(@RequestParam String oldLicenseNumber) {
        return this.licenseRepository.findByOldLicenseNumber(oldLicenseNumber) != null;
    }
}

