/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.transactions.digisign;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.tl.entity.License;
import org.egov.tl.service.LicenseCertificateDigiSignService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.CacheControl;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/tradelicense"})
public class LicenseCertificateDigiSignController {
    @Qualifier(value="fileStoreService")
    @Autowired
    private FileStoreService fileStoreService;
    @Autowired
    private LicenseCertificateDigiSignService licenseCertificateDigiSignService;

    @GetMapping(value={"/digisign-transition"})
    public String licenseDigiSignTransition(@RequestParam String[] fileStoreIds, @RequestParam String[] applicationNumbers, Model model) {
        this.licenseCertificateDigiSignService.digitalSignTransition(Arrays.asList(applicationNumbers));
        model.addAttribute("successMessage", (Object)"Digitally Signed Successfully");
        model.addAttribute("fileStoreId", (Object)(fileStoreIds.length == 1 ? fileStoreIds[0] : ""));
        model.addAttribute("applnum", (Object)(applicationNumbers.length == 1 ? applicationNumbers[0] : ""));
        return "digitalSignature-success";
    }

    @GetMapping(value={"/download/digisign-certificate"})
    @ResponseBody
    public ResponseEntity<InputStreamResource> downloadSignedLicenseCertificate(@RequestParam String file, @RequestParam String applnum) {
        try {
            File signedFile = this.fileStoreService.fetch(file, "TL");
            byte[] bytes = FileUtils.readFileToByteArray((File)signedFile);
            return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.parseMediaType((String)"application/pdf")).cacheControl(CacheControl.noCache())).contentLength((long)bytes.length).header("content-disposition", new String[]{"inline;filename=\"" + applnum + ".pdf\""})).body((Object)new InputStreamResource((InputStream)new ByteArrayInputStream(bytes)));
        }
        catch (IOException e) {
            throw new ApplicationRuntimeException("Error while reading file", (Throwable)e);
        }
    }

    @GetMapping(value={"/bulk-digisign"})
    public String showLicenseBulkDigiSignForm(Model model) {
        model.addAttribute("licenses", (Object)this.licenseCertificateDigiSignService.getLicensePendingForDigiSign());
        return "license-bulk-digisign-form";
    }

    @PostMapping(value={"/bulk-digisign"})
    public String bulkDigitalSignature(@RequestParam List<Long> licenseIds, Model model) {
        List licenses = this.licenseCertificateDigiSignService.generateLicenseCertificateForDigiSign(licenseIds);
        List fileStoreIds = licenses.parallelStream().map(License::getDigiSignedCertFileStoreId).collect(Collectors.toList());
        List applicaitonNumbers = licenses.parallelStream().map(License::getApplicationNumber).collect(Collectors.toList());
        model.addAttribute("fileStoreIds", (Object)String.join((CharSequence)",", fileStoreIds));
        model.addAttribute("applicationNo", (Object)String.join((CharSequence)",", applicaitonNumbers));
        model.addAttribute("ulbCode", (Object)ApplicationThreadLocals.getCityCode());
        return "license-bulk-digisign-forward";
    }
}

