/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.transactions.demand;

import java.util.Collection;
import org.egov.commons.CFinancialYear;
import org.egov.commons.service.CFinancialYearService;
import org.egov.infra.utils.JsonUtils;
import org.egov.tl.entity.DemandGenerationLogDetail;
import org.egov.tl.entity.TradeLicense;
import org.egov.tl.entity.contracts.DemandGenerationRequest;
import org.egov.tl.service.DemandGenerationService;
import org.egov.tl.service.TradeLicenseService;
import org.egov.tl.web.response.adaptor.DemandGenerationResponseAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/demand"})
public class DemandGenerationController {
    @Autowired
    private DemandGenerationService demandGenerationService;
    @Autowired
    private CFinancialYearService financialYearService;
    @Autowired
    private TradeLicenseService tradeLicenseService;

    @GetMapping(value={"generate"})
    public String newForm(Model model) {
        CFinancialYear financialYear = this.financialYearService.getCurrentFinancialYear();
        model.addAttribute("demandGenerationLogDetails", (Object)JsonUtils.toJSON((Collection)this.demandGenerationService.getDemandGenerationLog(financialYear).getDetails(), DemandGenerationLogDetail.class, DemandGenerationResponseAdaptor.class));
        model.addAttribute("licenseIds", (Object)this.tradeLicenseService.getLicenseIdsForDemandGeneration(financialYear));
        model.addAttribute("installmentYear", (Object)financialYear.getFinYearRange());
        return "demand-generate";
    }

    @PostMapping(value={"generate"})
    @ResponseBody
    public String generateDemand(DemandGenerationRequest demandGenerationRequest) {
        String demandGenerationLogJSON = JsonUtils.toJSON((Collection)this.demandGenerationService.generateDemand(demandGenerationRequest), DemandGenerationLogDetail.class, DemandGenerationResponseAdaptor.class);
        this.demandGenerationService.updateDemandGenerationLog(this.financialYearService.getCurrentFinancialYear());
        return demandGenerationLogJSON;
    }

    @GetMapping(value={"generate/{licenseId}"})
    public String generateDemandForLicense(@PathVariable Long licenseId, Model model) {
        model.addAttribute("licenseNumber", (Object)((TradeLicense)this.tradeLicenseService.getLicenseById(licenseId)).getLicenseNumber());
        model.addAttribute("financialYear", (Object)this.financialYearService.getLatestFinancialYear().getFinYearRange());
        return "demandgenerate-result";
    }

    @PostMapping(value={"generate/{licenseId}"})
    public String generateDemandForLicense(@PathVariable Long licenseId, RedirectAttributes redirectAttrs) {
        boolean generationStatus = this.demandGenerationService.generateLicenseDemand(licenseId);
        redirectAttrs.addFlashAttribute("message", (Object)(generationStatus ? "msg.demand.generation.completed" : "msg.demand.generation.incomplete"));
        return "redirect:/demand/generate/" + licenseId;
    }
}

