/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.transactions;

import java.util.List;
import java.util.Map;
import org.egov.infra.reporting.engine.ReportDisposition;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.util.ReportUtil;
import org.egov.tl.entity.LicenseDocument;
import org.egov.tl.service.TradeLicenseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/license"})
public class LicenseController {
    @Autowired
    private TradeLicenseService tradeLicenseService;

    @GetMapping(value={"/document/{licenseId}"}, produces={"application/json"})
    @ResponseBody
    public Map<String, Map<String, List<LicenseDocument>>> getAttachedDocument(@PathVariable Long licenseId) {
        return this.tradeLicenseService.getAttachedDocument(licenseId);
    }

    @GetMapping(value={"/acknowledgement/{licenseId}"})
    @ResponseBody
    public ResponseEntity<InputStreamResource> acknowledgment(@PathVariable Long licenseId) {
        ReportOutput reportOutput = this.tradeLicenseService.generateAcknowledgment(licenseId);
        reportOutput.setReportDisposition(ReportDisposition.ATTACHMENT);
        return ReportUtil.reportAsResponseEntity((ReportOutput)reportOutput);
    }
}

