/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.transactions;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.util.ReportUtil;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.utils.StringUtils;
import org.egov.tl.service.TradeLicenseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.CacheControl;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/license/generate/closure-notice"})
public class ClosureNoticeController {
    @Autowired
    private TradeLicenseService tradeLicenseService;

    @GetMapping
    public String searchClosureNotice() {
        return "search-closure-notice";
    }

    @GetMapping(value={"/"})
    @ResponseBody
    public ResponseEntity<InputStreamResource> closureNotice(@RequestParam String reportFormat) {
        ReportOutput reportOutput = this.tradeLicenseService.generateClosureNotice(reportFormat);
        if (reportFormat.equalsIgnoreCase("print")) {
            return ReportUtil.reportAsResponseEntity((ReportOutput)reportOutput);
        }
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.APPLICATION_OCTET_STREAM).cacheControl(CacheControl.noCache())).contentLength((long)reportOutput.getReportOutputData().length).header("content-disposition", new String[]{String.format("attachment;filename=\"%s\"", StringUtils.append((String)"tl_closure_notice_", (String)DateUtils.currentDateToFileNameFormat()) + ".zip")})).body((Object)new InputStreamResource((InputStream)new ByteArrayInputStream(reportOutput.getReportOutputData())));
    }
}

