/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.search;

import java.util.Collections;
import java.util.List;
import org.egov.infra.web.support.ui.DataTable;
import org.egov.tl.entity.contracts.SearchForm;
import org.egov.tl.service.LicenseCategoryService;
import org.egov.tl.service.LicenseStatusService;
import org.egov.tl.service.TradeLicenseService;
import org.egov.tl.web.response.adaptor.SearchTradeResultHelperAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/search"})
public class SearchTradeController {
    @Autowired
    private LicenseCategoryService licenseCategoryService;
    @Autowired
    private TradeLicenseService tradeLicenseService;
    @Autowired
    private LicenseStatusService licenseStatusService;

    @ModelAttribute(value="searchForm")
    public SearchForm searchForm() {
        return new SearchForm();
    }

    @GetMapping(value={"license"})
    public String searchLicenseForm(Model model) {
        model.addAttribute("categoryList", (Object)this.licenseCategoryService.getCategories());
        model.addAttribute("subCategoryList", Collections.emptyList());
        model.addAttribute("statusList", (Object)this.licenseStatusService.findAll());
        return "searchtrade-license";
    }

    @PostMapping(value={"license"}, produces={"text/plain"})
    @ResponseBody
    public String searchLicense(SearchForm searchForm) {
        return new DataTable(this.tradeLicenseService.searchTradeLicense(searchForm), (long)searchForm.draw()).toJson(SearchTradeResultHelperAdaptor.class);
    }

    @GetMapping(value={"autocomplete"}, produces={"application/json"})
    @ResponseBody
    public List<String> autocompleteSearch(@RequestParam String searchParamValue, @RequestParam String searchParamType) {
        return this.tradeLicenseService.getTradeLicenseForGivenParam(searchParamValue, searchParamType);
    }
}

