/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.reports;

import org.egov.infra.reporting.engine.ReportDisposition;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.util.ReportUtil;
import org.egov.infra.utils.StringUtils;
import org.egov.infra.web.support.ui.DataTable;
import org.egov.tl.entity.contracts.InstallmentWiseDCBRequest;
import org.egov.tl.entity.view.InstallmentWiseDCB;
import org.egov.tl.service.InstallmentwiseDCBReportService;
import org.egov.tl.web.response.adaptor.InstallmentWiseDCBResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report/dcb/yearwise"})
public class InstallmentwiseDCBReportController {
    @Autowired
    private InstallmentwiseDCBReportService installmentWiseDCBService;

    @ModelAttribute
    public InstallmentWiseDCB installmentWiseDCBForm() {
        return new InstallmentWiseDCB();
    }

    @GetMapping(value={"/search"})
    public String search(Model model) {
        model.addAttribute("financialYears", (Object)this.installmentWiseDCBService.getFinancialYears());
        return "yearwiseDCBReport-search";
    }

    @PostMapping(value={"/search"}, produces={"text/plain"})
    @ResponseBody
    public String result(InstallmentWiseDCBRequest installmentWiseDCBRequest) {
        return new DataTable(this.installmentWiseDCBService.getReportResult(installmentWiseDCBRequest), (long)installmentWiseDCBRequest.draw()).toJson(InstallmentWiseDCBResponse.class);
    }

    @GetMapping(value={"/grand-total"})
    @ResponseBody
    public Object[] yearWiseGrandTotal(InstallmentWiseDCBRequest installmentWiseDCBRequest) {
        return this.installmentWiseDCBService.reportGrandTotal(installmentWiseDCBRequest);
    }

    @GetMapping(value={"/download"})
    @ResponseBody
    public ResponseEntity<InputStreamResource> downloadYearWiseReport(InstallmentWiseDCBRequest reportCriteria) {
        ReportOutput reportOutput = this.installmentWiseDCBService.generateInstallmentwiseDCBReport(reportCriteria);
        reportOutput.setReportName(StringUtils.appendTimestamp((String)"tl_installment_yearwise_dcb_report"));
        reportOutput.setReportDisposition(ReportDisposition.ATTACHMENT);
        return ReportUtil.reportAsResponseEntity((ReportOutput)reportOutput);
    }
}

