/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.reports;

import java.util.Date;
import java.util.List;
import org.egov.collection.entity.es.CollectionDocument;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.tl.entity.contracts.DCRSearchRequest;
import org.egov.tl.service.DailyCollectionReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/reports/dailycollectionreport"})
public class DailyCollectionReportController {
    @Autowired
    public EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private DailyCollectionReportService dCRService;

    @ModelAttribute(value="dcrSearchRequest")
    public DCRSearchRequest dcrSearchRequest() {
        return new DCRSearchRequest();
    }

    @RequestMapping(method={RequestMethod.GET})
    public String search(Model model) {
        model.addAttribute("currentDate", (Object)new Date());
        model.addAttribute("operators", (Object)this.dCRService.getCollectionOperators());
        model.addAttribute("status", (Object)this.egwStatusHibernateDAO.getStatusByModule("ReceiptHeader"));
        model.addAttribute("wards", (Object)this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("WARD", "REVENUE"));
        return "dcr-search";
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public List<CollectionDocument> searchCollection(@ModelAttribute DCRSearchRequest searchRequest) {
        return this.dCRService.searchDailyCollection(searchRequest);
    }
}

