/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.reports;

import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.reporting.engine.ReportDisposition;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.util.ReportUtil;
import org.egov.infra.utils.StringUtils;
import org.egov.infra.web.support.ui.DataTable;
import org.egov.tl.entity.contracts.DCBReportSearchRequest;
import org.egov.tl.entity.view.DCBReportResult;
import org.egov.tl.service.DCBReportService;
import org.egov.tl.web.response.adaptor.DCBReportResponseAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report/dcb"})
public class DCBReportController {
    private static final String LICENSE = "license";
    private static final String REPORT_TYPE_ATTRIB_NAME = "reportType";
    @Autowired
    private DCBReportService dCBReportService;
    @Autowired
    private BoundaryService boundaryService;

    @ModelAttribute(value="dCBReportResult")
    public DCBReportResult dCBReportResultModel() {
        return new DCBReportResult();
    }

    @GetMapping(value={"search"})
    public String dcbSearchForm(Model model) {
        model.addAttribute("mode", (Object)LICENSE);
        model.addAttribute(REPORT_TYPE_ATTRIB_NAME, (Object)LICENSE);
        model.addAttribute("wardList", (Object)this.boundaryService.getBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE"));
        return "dCBReport-search";
    }

    @PostMapping(value={"search"}, produces={"text/plain"})
    @ResponseBody
    public String searchDCBReport(DCBReportSearchRequest searchRequest) {
        return new DataTable(this.dCBReportService.pagedDCBRecords(searchRequest), (long)searchRequest.draw()).toJson(DCBReportResponseAdaptor.class);
    }

    @GetMapping(value={"grand-total"})
    @ResponseBody
    public Object[] dcbGrandTotal(DCBReportSearchRequest searchRequest) {
        return this.dCBReportService.dcbGrandTotal(searchRequest);
    }

    @GetMapping(value={"download"})
    @ResponseBody
    public ResponseEntity<InputStreamResource> dcbReportDownload(DCBReportSearchRequest reportCriteria) {
        ReportOutput reportOutput = this.dCBReportService.generateDCBReport(reportCriteria);
        reportOutput.setReportName(StringUtils.appendTimestamp((String)"dcb_report"));
        reportOutput.setReportDisposition(ReportDisposition.ATTACHMENT);
        return ReportUtil.reportAsResponseEntity((ReportOutput)reportOutput);
    }
}

