/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.masters.validity;

import java.util.Collection;
import java.util.List;
import org.egov.infra.utils.JsonUtils;
import org.egov.tl.entity.LicenseCategory;
import org.egov.tl.entity.NatureOfBusiness;
import org.egov.tl.entity.Validity;
import org.egov.tl.service.LicenseCategoryService;
import org.egov.tl.service.NatureOfBusinessService;
import org.egov.tl.service.ValidityService;
import org.egov.tl.web.response.adaptor.ValidityResponseAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/validity"})
public class ViewValidityController {
    @Autowired
    private ValidityService validityService;
    @Autowired
    private NatureOfBusinessService natureOfBusinessService;
    @Autowired
    private LicenseCategoryService licenseCategoryService;

    @ModelAttribute
    public List<NatureOfBusiness> natureOfBusinesses() {
        return this.natureOfBusinessService.getNatureOfBusinesses();
    }

    @ModelAttribute
    public List<LicenseCategory> licenseCategories() {
        return this.licenseCategoryService.getCategoriesOrderByName();
    }

    @GetMapping(value={"/view/{id}"})
    public String viewValidity(@PathVariable(value="id") Long id, Model model) {
        model.addAttribute("validity", (Object)this.validityService.findOne(id));
        return "validity-view";
    }

    @GetMapping(value={"/search"})
    public String showValiditySearchForm(Model model) {
        model.addAttribute("validity", (Object)new Validity());
        return "validity-search";
    }

    @PostMapping(value={"/search"}, produces={"text/plain"})
    @ResponseBody
    public String searchValidity(@RequestParam(required=false) Long natureOfBusiness, @RequestParam(required=false) Long licenseCategory) {
        return "{ \"data\":" + JsonUtils.toJSON((Collection)this.validityService.search(natureOfBusiness, licenseCategory), Validity.class, ValidityResponseAdaptor.class) + "}";
    }
}

