/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.masters.validity;

import java.util.List;
import javax.validation.Valid;
import org.egov.tl.entity.LicenseCategory;
import org.egov.tl.entity.NatureOfBusiness;
import org.egov.tl.entity.Validity;
import org.egov.tl.service.LicenseCategoryService;
import org.egov.tl.service.NatureOfBusinessService;
import org.egov.tl.service.ValidityService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/validity/create"})
public class CreateValidityController {
    @Autowired
    private ValidityService validityService;
    @Autowired
    private NatureOfBusinessService natureOfBusinessService;
    @Autowired
    private LicenseCategoryService licenseCategoryService;

    @ModelAttribute
    public List<NatureOfBusiness> natureOfBusinesses() {
        return this.natureOfBusinessService.getNatureOfBusinesses();
    }

    @ModelAttribute
    public List<LicenseCategory> licenseCategories() {
        return this.licenseCategoryService.getCategoriesOrderByName();
    }

    @GetMapping
    public String showValidityCreateForm(@ModelAttribute Validity validity) {
        return "validity-create";
    }

    @PostMapping
    public String createValidity(@Valid @ModelAttribute Validity validity, BindingResult bindingResult, RedirectAttributes responseAttribs) {
        if (!validity.hasValidValues()) {
            bindingResult.rejectValue("basedOnFinancialYear", "validity.value.notset");
        }
        if (bindingResult.hasErrors()) {
            return "validity-create";
        }
        this.validityService.create(validity);
        responseAttribs.addFlashAttribute("message", (Object)"msg.validity.success");
        return "redirect:/validity/view/" + validity.getId();
    }
}

