/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.masters.uom;

import javax.validation.Valid;
import org.egov.tl.entity.UnitOfMeasurement;
import org.egov.tl.service.UnitOfMeasurementService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/licenseunitofmeasurement"})
public class UpdateUnitOfMeasurementController {
    @Autowired
    private UnitOfMeasurementService unitOfMeasurementService;

    @ModelAttribute
    public UnitOfMeasurement unitOfMeasurement(@PathVariable String code) {
        return this.unitOfMeasurementService.getUnitOfMeasurementByCode(code);
    }

    @GetMapping(value={"/update/{code}"})
    public String showUpdateUomForm() {
        return "uom-update";
    }

    @PostMapping(value={"/update/{code}"})
    public String updateUom(@ModelAttribute @Valid UnitOfMeasurement unitOfMeasurement, BindingResult bindingResult, RedirectAttributes responseAttrbs) {
        if (bindingResult.hasErrors()) {
            return "uom-update";
        }
        this.unitOfMeasurementService.save(unitOfMeasurement);
        responseAttrbs.addFlashAttribute("message", (Object)"msg.success.uom.update");
        return "redirect:/licenseunitofmeasurement/view/" + unitOfMeasurement.getCode();
    }
}

