/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.masters.subcategory;

import javax.validation.Valid;
import org.egov.tl.entity.LicenseSubCategory;
import org.egov.tl.service.FeeTypeService;
import org.egov.tl.service.LicenseCategoryService;
import org.egov.tl.service.LicenseSubCategoryService;
import org.egov.tl.service.UnitOfMeasurementService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/licensesubcategory"})
public class UpdateSubCategoryController {
    @Autowired
    private LicenseSubCategoryService licenseSubCategoryService;
    @Autowired
    private LicenseCategoryService licenseCategoryService;
    @Autowired
    private UnitOfMeasurementService unitOfMeasurementService;
    @Autowired
    private FeeTypeService feeTypeService;

    @ModelAttribute
    public LicenseSubCategory licenseSubCategory(@PathVariable String code) {
        return this.licenseSubCategoryService.getSubCategoryByCode(code);
    }

    @GetMapping(value={"/update/{code}"})
    public String showSubCategoryUpdateForm(Model model) {
        this.prepareSubCategoryAssociations(model);
        return "subcategory-update";
    }

    @PostMapping(value={"/update/{code}"})
    public String updateSubCategory(@ModelAttribute @Valid LicenseSubCategory licenseSubCategory, BindingResult bindingResult, RedirectAttributes responseAttrbs, Model model) {
        if (bindingResult.hasErrors()) {
            this.prepareSubCategoryAssociations(model);
            return "subcategory-update";
        }
        this.licenseSubCategoryService.updateSubCategory(licenseSubCategory);
        responseAttrbs.addFlashAttribute("message", (Object)"msg.success.subcategory.update");
        return "redirect:/licensesubcategory/view/" + licenseSubCategory.getCode();
    }

    private void prepareSubCategoryAssociations(Model model) {
        model.addAttribute("licenseCategories", (Object)this.licenseCategoryService.getCategories());
        model.addAttribute("licenseFeeTypes", (Object)this.feeTypeService.findAll());
        model.addAttribute("licenseUomTypes", (Object)this.unitOfMeasurementService.getAllUOM());
    }
}

