/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.masters.subcategory;

import java.util.List;
import javax.validation.Valid;
import org.egov.tl.entity.FeeType;
import org.egov.tl.entity.LicenseCategory;
import org.egov.tl.entity.LicenseSubCategory;
import org.egov.tl.entity.UnitOfMeasurement;
import org.egov.tl.entity.enums.RateTypeEnum;
import org.egov.tl.service.FeeTypeService;
import org.egov.tl.service.LicenseCategoryService;
import org.egov.tl.service.LicenseSubCategoryService;
import org.egov.tl.service.UnitOfMeasurementService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/licensesubcategory"})
public class CreateSubCategoryController {
    @Autowired
    private LicenseSubCategoryService licenseSubCategoryService;
    @Autowired
    private LicenseCategoryService licenseCategoryService;
    @Autowired
    private UnitOfMeasurementService unitOfMeasurementService;
    @Autowired
    private FeeTypeService feeTypeService;

    @ModelAttribute
    public LicenseSubCategory licenseSubCategory() {
        return new LicenseSubCategory();
    }

    @ModelAttribute(value="licenseCategories")
    public List<LicenseCategory> licenseCategories() {
        return this.licenseCategoryService.getCategories();
    }

    @ModelAttribute(value="licenseUomTypes")
    public List<UnitOfMeasurement> activeUOMs() {
        return this.unitOfMeasurementService.getAllActiveUOM();
    }

    @ModelAttribute(value="licenseFeeTypes")
    public List<FeeType> feeTypes() {
        return this.feeTypeService.findAll();
    }

    @GetMapping(value={"/create"})
    public String showCreateSubCategoryForm(Model model) {
        model.addAttribute("code", (Object)this.licenseSubCategoryService.getSubCategoryCode());
        model.addAttribute("rateTypes", (Object)RateTypeEnum.values());
        return "subcategory-create";
    }

    @PostMapping(value={"/create"})
    public String createSubCategory(@Valid LicenseSubCategory licenseSubCategory, BindingResult bindingResult, RedirectAttributes responseAttrbs) {
        if (bindingResult.hasErrors()) {
            return "subcategory-create";
        }
        this.licenseSubCategoryService.createSubCategory(licenseSubCategory);
        responseAttrbs.addFlashAttribute("message", (Object)"msg.subcategory.save.success");
        return "redirect:/licensesubcategory/view/" + licenseSubCategory.getCode();
    }
}

