/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.masters.penaltyrates;

import java.util.List;
import org.egov.tl.entity.LicenseAppType;
import org.egov.tl.entity.PenaltyRates;
import org.egov.tl.entity.contracts.PenaltyForm;
import org.egov.tl.service.LicenseAppTypeService;
import org.egov.tl.service.PenaltyRatesService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/penaltyRates"})
public class PenaltyRatesController {
    private static final String PENALTYRATE_RESULT = "penaltyRates-result";
    @Autowired
    private PenaltyRatesService penaltyRatesService;
    @Autowired
    private LicenseAppTypeService licenseAppTypeService;

    @ModelAttribute(value="licenseAppTypes")
    public List<LicenseAppType> licenseAppTypes() {
        return this.licenseAppTypeService.findAllLicenseAppType();
    }

    @GetMapping(value={"/create"})
    public String penaltyRatesForm(@ModelAttribute PenaltyForm penaltyForm) {
        return "penaltyRates-create";
    }

    @PostMapping(value={"/create"})
    public String penaltyRatesCreate(@ModelAttribute PenaltyForm penaltyForm, BindingResult bindingResult, RedirectAttributes redirectAttributes) {
        if (bindingResult.hasErrors()) {
            return PENALTYRATE_RESULT;
        }
        this.penaltyRatesService.create(penaltyForm.getPenaltyRates());
        redirectAttributes.addFlashAttribute("message", (Object)"msg.penaltyRate.created");
        return "penaltyRates-view";
    }

    @GetMapping(value={"/view"})
    public String searchForm(@ModelAttribute PenaltyForm penaltyForm) {
        return "penaltyRates-search";
    }

    @GetMapping(value={"/search"})
    public String search(@ModelAttribute PenaltyForm penaltyForm, BindingResult errors, Model model) {
        if (errors.hasErrors()) {
            return PENALTYRATE_RESULT;
        }
        penaltyForm.setPenaltyRatesList(this.penaltyRatesService.search(penaltyForm.getLicenseAppType().getId()));
        model.addAttribute("penaltyForm", (Object)penaltyForm);
        return PENALTYRATE_RESULT;
    }

    @GetMapping(value={"/searchview"})
    public String searchview(@ModelAttribute PenaltyForm penaltyForm, BindingResult errors, Model model) {
        if (errors.hasErrors()) {
            return "penaltyRates-search";
        }
        penaltyForm.setPenaltyRatesList(this.penaltyRatesService.search(penaltyForm.getLicenseAppType().getId()));
        model.addAttribute("penaltyForm", (Object)penaltyForm);
        return "penaltyRates-viewResult";
    }

    @GetMapping(value={"/deleterow"}, produces={"text/plain"})
    @ResponseBody
    public String removePenaltyRate(@RequestParam Long penaltyRateId) {
        PenaltyRates penaltyRates = this.penaltyRatesService.findOne(penaltyRateId);
        if (penaltyRates != null) {
            this.penaltyRatesService.delete(penaltyRates);
        }
        return "success";
    }
}

