/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.masters.feematrix;

import java.util.Collection;
import java.util.List;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.infra.utils.JsonUtils;
import org.egov.tl.entity.FeeMatrix;
import org.egov.tl.entity.LicenseCategory;
import org.egov.tl.service.FeeMatrixService;
import org.egov.tl.service.LicenseCategoryService;
import org.egov.tl.web.response.adaptor.FeeMatrixResponseAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/feematrix"})
public class ViewFeeMatrixController {
    @Autowired
    private LicenseCategoryService licenseCategoryService;
    @Autowired
    private FinancialYearDAO financialYearDAO;
    @Autowired
    private FeeMatrixService feeMatrixService;

    @ModelAttribute
    public List<LicenseCategory> licenseCategories() {
        return this.licenseCategoryService.getCategoriesOrderByName();
    }

    @ModelAttribute(value="financialYears")
    public List<CFinancialYear> financialYears() {
        return this.financialYearDAO.getAllActiveFinancialYearList();
    }

    @GetMapping(value={"view/{id}"})
    public String view(@PathVariable Long id, Model model) {
        model.addAttribute("feeMatrix", (Object)this.feeMatrixService.getFeeMatrixById(id));
        return "feematrix-view";
    }

    @GetMapping(value={"search"})
    public String searchForm(Model model) {
        model.addAttribute("feeMatrix", (Object)new FeeMatrix());
        return "feematrix-search";
    }

    @PostMapping(value={"search"}, produces={"text/plain"})
    @ResponseBody
    public String search(@RequestParam(required=false) Long categoryId, @RequestParam(required=false) Long subcategoryId, @RequestParam(required=false) Long financialYearId) {
        return "{ \"data\":" + JsonUtils.toJSON((Collection)this.feeMatrixService.getFeeMatrix(categoryId, subcategoryId, financialYearId), FeeMatrix.class, FeeMatrixResponseAdaptor.class) + "}";
    }
}

