/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.actions.viewtradelicense;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.eis.entity.Assignment;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.web.struts.annotation.ValidationErrorPageExt;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.pims.commons.Position;
import org.egov.tl.entity.License;
import org.egov.tl.entity.TradeLicense;
import org.egov.tl.entity.WorkflowBean;
import org.egov.tl.service.AbstractLicenseService;
import org.egov.tl.service.TradeLicenseService;
import org.egov.tl.web.actions.BaseLicenseAction;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Results(value={@Result(name={"report"}, location="viewTradeLicense-report.jsp"), @Result(name={"message"}, location="viewTradeLicense-message.jsp"), @Result(name={"closure"}, location="viewTradeLicense-closure.jsp"), @Result(name={"digisigncertificate"}, type="redirect", location="/tradelicense/download/digisign-certificate", params={"file", "${digiSignedFile}", "applnum", "${applNum}"})})
public class ViewTradeLicenseAction
extends BaseLicenseAction<TradeLicense> {
    private static final long serialVersionUID = 1L;
    protected TradeLicense tradeLicense = new TradeLicense();
    private Long licenseid;
    private String url;
    private Boolean enableState;
    private String digiSignedFile;
    private String applNum;
    @Autowired
    private TradeLicenseService tradeLicenseService;

    public TradeLicense getModel() {
        return this.tradeLicense;
    }

    @Action(value="/viewtradelicense/viewTradeLicense-showForApproval")
    public String showForApproval() throws IOException {
        this.tradeLicense = (TradeLicense)this.tradeLicenseService.getLicenseById(this.license().getId());
        return super.showForApproval();
    }

    @Action(value="/viewtradelicense/viewTradeLicense-view")
    public String view() {
        if (this.license() != null && this.license().getId() != null) {
            this.tradeLicense = (TradeLicense)this.tradeLicenseService.getLicenseById(this.license().getId());
        } else if (this.applicationNo != null && !this.applicationNo.isEmpty()) {
            this.tradeLicense = (TradeLicense)this.tradeLicenseService.getLicenseByApplicationNumber(this.applicationNo);
        }
        this.licenseHistory = this.tradeLicenseService.populateHistory(this.tradeLicense);
        return "view";
    }

    @ValidationErrorPage(value="report")
    @Action(value="/viewtradelicense/viewTradeLicense-generateCertificate")
    public String generateCertificate() {
        this.setLicenseIdIfServletRedirect();
        this.tradeLicense = (TradeLicense)this.tradeLicenseService.getLicenseById(this.license().getId());
        if (this.tradeLicense.getDigiSignedCertFileStoreId() != null) {
            this.setDigiSignedFile(this.license().getDigiSignedCertFileStoreId());
            this.setApplNum(this.license().getApplicationNumber());
            return "digisigncertificate";
        }
        this.reportId = this.reportViewerUtil.addReportToTempCache(this.tradeLicenseService.generateLicenseCertificate((License)this.license(), false));
        return "report";
    }

    @ValidationErrorPage(value="report")
    @Action(value="/viewtradelicense/generate-provisional-certificate")
    public String generateProvisionalCertificate() {
        this.setLicenseIdIfServletRedirect();
        this.tradeLicense = (TradeLicense)this.tradeLicenseService.getLicenseById(this.license().getId());
        this.reportId = this.reportViewerUtil.addReportToTempCache(this.tradeLicenseService.generateLicenseCertificate((License)this.license(), true));
        return "report";
    }

    private void setLicenseIdIfServletRedirect() {
        if (this.tradeLicense.getId() == null && this.getSession().get("model.id") != null) {
            this.tradeLicense.setId(Long.valueOf((Long)this.getSession().get("model.id")));
            this.getSession().remove("model.id");
        }
    }

    protected TradeLicense license() {
        return this.tradeLicense;
    }

    protected AbstractLicenseService<TradeLicense> licenseService() {
        return this.tradeLicenseService;
    }

    public WorkflowBean getWorkflowBean() {
        return this.workflowBean;
    }

    public void setWorkflowBean(WorkflowBean workflowBean) {
        this.workflowBean = workflowBean;
    }

    public String getReportId() {
        return this.reportId;
    }

    @Action(value="/viewtradelicense/showclosureform")
    public String showClosureForm() throws IOException {
        this.prepareClosureForm();
        this.setUrl("viewtradelicense/saveclosure.action?model.id=");
        if (this.tradeLicense.hasState() && !this.tradeLicense.transitionCompleted()) {
            ServletActionContext.getResponse().setContentType("text/html");
            ServletActionContext.getResponse().getWriter().write("<center style='color:red;font-weight:bolder'>" + this.tradeLicense.getLicenseAppType().getName() + " License workflow is in progress !</center>");
            return null;
        }
        return "closure";
    }

    public void prepareClosureForm() {
        if (this.license() != null && this.license().getId() != null) {
            this.tradeLicense = (TradeLicense)this.tradeLicenseService.getLicenseById(this.license().getId());
        }
        if (this.tradeLicense.hasState() && this.tradeLicense.getCurrentState().getValue().equalsIgnoreCase("SI/SS Approved")) {
            this.setEnableState(Boolean.valueOf(true));
        }
    }

    @Action(value="/viewtradelicense/viewTradeLicense-closure")
    public String viewClosure() {
        this.prepareClosureForm();
        this.setUrl("viewtradelicense/viewTradeLicense-cancelLicense.action?model.id=");
        this.licenseHistory = this.tradeLicenseService.populateHistory(this.tradeLicense);
        return "closure";
    }

    @ValidationErrorPageExt(action="closure", makeCall=true, toMethod="prepareClosureForm")
    @Action(value="/viewtradelicense/saveclosure")
    public String saveClosure() {
        this.populateWorkflowBean();
        if (this.getLicenseid() != null) {
            this.tradeLicense = (TradeLicense)this.tradeLicenseService.getLicenseById(this.getLicenseid());
            if (this.tradeLicenseService.currentUserIsMeeseva().booleanValue()) {
                this.tradeLicense.setApplicationNumber(this.getApplicationNo());
                this.tradeLicenseService.closureWithMeeseva((License)this.tradeLicense, this.workflowBean);
            } else {
                this.tradeLicenseService.saveClosure((License)this.tradeLicense, this.workflowBean);
            }
        }
        if (this.hasCSCPublicRole().booleanValue()) {
            this.addActionMessage(this.getText("license.closure.initiated"));
        } else if ("Forward".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
            List assignments = this.assignmentService.getAssignmentsForPosition(this.workflowBean.getApproverPositionId());
            String nextDesgn = !assignments.isEmpty() ? ((Assignment)assignments.get(0)).getDesignation().getName() : "";
            String userName = !assignments.isEmpty() ? ((Assignment)assignments.get(0)).getEmployee().getName() : "";
            this.addActionMessage(this.getText("license.closure.sent") + " " + nextDesgn + " - " + userName);
        }
        return this.tradeLicenseService.currentUserIsMeeseva() != false ? "meesevaAck" : "message";
    }

    @Action(value="/viewtradelicense/viewTradeLicense-cancelLicense")
    public String updateLicenseClosure() {
        this.populateWorkflowBean();
        if (this.getLicenseid() != null) {
            this.tradeLicense = (TradeLicense)this.tradeLicenseService.getLicenseById(this.getLicenseid());
            WorkFlowMatrix wfmatrix = this.tradeLicenseService.getWorkFlowMatrixApi((License)this.license(), this.workflowBean);
            if (!this.license().getCurrentState().getValue().equals(wfmatrix.getCurrentState())) {
                this.addActionMessage(this.getText("wf.item.processed"));
                return "message";
            }
            this.tradeLicenseService.cancelLicenseWorkflow((License)this.tradeLicense, this.workflowBean);
            if ("Forward".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
                List assignments = this.assignmentService.getAssignmentsForPosition(this.workflowBean.getApproverPositionId());
                String nextDesgn = !assignments.isEmpty() ? ((Assignment)assignments.get(0)).getDesignation().getName() : "";
                String userName = !assignments.isEmpty() ? ((Assignment)assignments.get(0)).getEmployee().getName() : "";
                this.addActionMessage(this.getText("license.closure.sent") + " " + nextDesgn + " - " + userName);
            } else if ("Reject".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
                if (this.license().getState().getValue().contains("Rejected")) {
                    List assignments = this.assignmentService.getAssignmentsForPosition(((Position)this.license().getState().getInitiatorPosition()).getId());
                    String userName = !assignments.isEmpty() ? ((Assignment)assignments.get(0)).getEmployee().getName() : "";
                    this.addActionMessage(this.getText("license.closure.rejectedfirst") + " " + ((Position)this.license().getState().getInitiatorPosition()).getDeptDesig().getDesignation().getName() + " - " + " " + userName);
                } else {
                    this.addActionMessage(this.getText("license.closure.rejected") + " " + this.license().getLicenseNumber());
                }
            } else {
                this.addActionMessage(this.getText("license.closure.msg") + this.license().getLicenseNumber());
            }
        }
        return "message";
    }

    public String getAdditionalRule() {
        return "CLOSURELICENSE";
    }

    public Long getLicenseid() {
        return this.licenseid;
    }

    public void setLicenseid(Long licenseid) {
        this.licenseid = licenseid;
    }

    public Boolean hasCSCPublicRole() {
        return this.securityUtils.getCurrentUser().hasAnyRole(new String[]{"CSC Operator", "MeeSeva Operator", "PUBLIC", "CITIZEN"});
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Boolean getEnableState() {
        return this.enableState;
    }

    public void setEnableState(Boolean enableState) {
        this.enableState = enableState;
    }

    public String getDigiSignedFile() {
        return this.digiSignedFile;
    }

    public void setDigiSignedFile(String digiSignedFile) {
        this.digiSignedFile = digiSignedFile;
    }

    public String getApplNum() {
        return this.applNum;
    }

    public void setApplNum(String applNum) {
        this.applNum = applNum;
    }

    public List<String> getValidActions() {
        ArrayList<String> validActions = new ArrayList();
        if (null == this.getModel() || null == this.getModel().getId() || this.getModel().getCurrentState() == null || this.getModel() != null && this.getModel().getCurrentState() != null && this.getModel().getCurrentState().isEnded()) {
            validActions = Arrays.asList("Forward");
        } else if (this.getModel().getCurrentState() != null) {
            validActions.addAll(this.customizedWorkFlowService.getNextValidActions(this.getModel().getStateType(), this.getWorkFlowDepartment(), this.getAmountRule(), this.getAdditionalRule(), this.getModel().getCurrentState().getValue(), this.getPendingActions(), this.getModel().getCreatedDate()));
            validActions.removeIf(validAction -> "Reassign".equals(validAction) && this.getModel().getState().getCreatedBy().getId().equals(ApplicationThreadLocals.getUserId()));
        }
        return validActions;
    }
}

