/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.actions.newtradelicense;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.web.struts.annotation.ValidationErrorPageExt;
import org.egov.pims.commons.Position;
import org.egov.tl.entity.License;
import org.egov.tl.entity.LicenseDocumentType;
import org.egov.tl.entity.Licensee;
import org.egov.tl.entity.TradeLicense;
import org.egov.tl.entity.WorkflowBean;
import org.egov.tl.entity.enums.ApplicationType;
import org.egov.tl.service.AbstractLicenseService;
import org.egov.tl.service.TradeLicenseService;
import org.egov.tl.utils.Constants;
import org.egov.tl.web.actions.BaseLicenseAction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;

@ParentPackage(value="egov")
@Results(value={@Result(name={"new"}, location="newTradeLicense-new.jsp"), @Result(name={"acknowledgement"}, location="newTradeLicense-acknowledgement.jsp"), @Result(name={"message"}, location="newTradeLicense-message.jsp"), @Result(name={"beforeRenew"}, location="newTradeLicense-beforeRenew.jsp"), @Result(name={"printAck"}, location="newTradeLicense-printAck.jsp"), @Result(name={"acknowledgement_renew"}, location="newTradeLicense-acknowledgement_renew.jsp")})
public class NewTradeLicenseAction
extends BaseLicenseAction<TradeLicense> {
    private static final long serialVersionUID = 1L;
    private TradeLicense tradeLicense = new TradeLicense();
    private List<LicenseDocumentType> documentTypes = new ArrayList();
    private Map<String, String> ownerShipTypeMap;
    private String mode;
    private String message;
    private String renewAppType;
    @Autowired
    @Qualifier(value="tradeLicenseService")
    private transient TradeLicenseService tradeLicenseService;
    @Autowired
    @Qualifier(value="parentMessageSource")
    private transient MessageSource licenseMessageSource;
    @Autowired
    private transient ReportService reportService;

    public NewTradeLicenseAction() {
        this.tradeLicense.setLicensee(new Licensee());
    }

    @SkipValidation
    @Action(value="/newtradelicense/newTradeLicense-newForm")
    public String newForm() {
        this.tradeLicense.setNewWorkflow(true);
        this.tradeLicense.setApplicationDate(new Date());
        return super.newForm();
    }

    @ValidationErrorPage(value="new")
    @Action(value="/newtradelicense/newTradeLicense-create")
    public String create() {
        return super.create((License)this.tradeLicense);
    }

    @SkipValidation
    @Action(value="/newtradelicense/newtradelicense-printAck")
    public String printAck() {
        this.reportId = this.reportViewerUtil.addReportToTempCache(this.getReportParamsForAcknowdgement((TradeLicense)this.tradeLicenseService.getLicenseById(this.tradeLicense.getId())));
        return "printAck";
    }

    public ReportOutput getReportParamsForAcknowdgement(TradeLicense license) {
        HttpServletRequest request = ServletActionContext.getRequest();
        String cityName = request.getSession().getAttribute("citymunicipalityname").toString();
        String city = request.getSession().getAttribute("cityname").toString();
        HashMap<String, String> reportParams = new HashMap<String, String>();
        reportParams.put("municipality", cityName);
        reportParams.put("cityname", city);
        reportParams.put("wardName", license.getParentBoundary().getName());
        reportParams.put("applicantName", license.getLicensee().getApplicantName());
        reportParams.put("acknowledgementNo", license.getApplicationNumber());
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        reportParams.put("currentDate", formatter.format(new Date()));
        reportParams.put("licenceAddress", license.getAddress());
        reportParams.put("dueDate", formatter.format(this.calculateDueDate(license)));
        reportParams.put("Party's Copy", "Party's Copy");
        reportParams.put("Office's Copy", "Office's Copy");
        reportParams.put("ApplicationCentre", this.licenseMessageSource.getMessage("msg.application.centre", (Object[])new String[]{license.getApplicationNumber()}, Locale.getDefault()));
        reportParams.put("appType", license.getLicenseAppType() != null ? ("New".equals(license.getLicenseAppType().getName()) ? "New Trade" : "Renewal of Trade") : "New");
        ReportRequest reportInput = new ReportRequest("tl_acknowledgement", (Object)license, reportParams);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=Acknowledgement.pdf");
        return this.reportService.createReport(reportInput);
    }

    public Date calculateDueDate(TradeLicense license) {
        Date currentDate = new Date();
        String slaNewTradeLicense = this.licenseMessageSource.getMessage("msg.newTradeLicense.sla", (Object[])new String[]{license.getApplicationNumber()}, Locale.getDefault());
        String slaRenewTradeLicense = this.licenseMessageSource.getMessage("msg.renewTradeLicense.sla", (Object[])new String[]{license.getApplicationNumber()}, Locale.getDefault());
        Date dueDate = license.isNewApplication() ? DateUtils.addDays((Date)currentDate, (int)Integer.parseInt(slaNewTradeLicense)) : DateUtils.addDays((Date)currentDate, (int)Integer.parseInt(slaRenewTradeLicense));
        return dueDate;
    }

    @Action(value="/newtradelicense/newTradeLicense-showForApproval")
    @SkipValidation
    public String showForApproval() throws IOException {
        this.documentTypes = this.tradeLicenseService.getDocumentTypesByApplicationType(ApplicationType.valueOf((String)this.license().getLicenseAppType().getName().toUpperCase()));
        if (!this.license().isNewWorkflow()) {
            if (this.license().getState().getValue().equals("License Created") || this.license().getState().getValue().contains("Commissioner approved") && this.license().getEgwStatus().getCode().equals("SECONDLVLCOLLECTIONPENDING")) {
                this.mode = "ACK";
                this.message = "Pending for Collection";
            } else if (this.license().getState().getValue().equals("First level fee collected") || this.license().getState().getValue().equals("SI/MHO approved")) {
                this.mode = "view";
            } else if (this.license().getState().getValue().contains("Rejected")) {
                this.mode = "editForReject";
            } else if (this.license().getState().getValue().contains("Revenue clerk approved")) {
                this.mode = "editForApproval";
            } else if (this.license().getState().getValue().contains("Second level fee collected") || this.license().getEgwStatus().getCode().equals("APPROVED") && this.license().getState().getValue().contains("Commissioner approved")) {
                this.mode = "disableApprover";
            } else if (this.licenseUtils.isDigitalSignEnabled().booleanValue() && this.license().getState().getValue().equals("Digital sign-Second level fee collected") || this.license().getState().getValue().equals("Digital signed") || this.license().getState().getValue().equals("Digital sign-Commissioner Approved no collection")) {
                this.mode = "disableApprover";
            }
        }
        if ("COLLECTIONPENDING".equals(this.license().getStatus().getStatusCode()) || "ACK".equals(this.license().getStatus().getStatusCode())) {
            this.message = "Pending for Collection";
        }
        List positionList = this.positionMasterService.getPositionsForEmployee(this.securityUtils.getCurrentUser().getId(), new Date());
        Position owner = (Position)this.license().currentAssignee();
        if (!positionList.isEmpty() && !positionList.contains(owner)) {
            ServletActionContext.getResponse().setContentType("text/html");
            ServletActionContext.getResponse().getWriter().write("<center style='color:red;font-weight:bolder'>Workflow item is in " + owner.getName() + " inbox !</center>");
            return null;
        }
        this.licenseHistory = this.tradeLicenseService.populateHistory(this.tradeLicense);
        return super.showForApproval();
    }

    @ValidationErrorPageExt(action="new", makeCall=true, toMethod="prepareShowForApproval")
    @Action(value="/newtradelicense/newTradeLicense-approve")
    public String approve() {
        if ("Submit".equals(this.workFlowAction) && this.mode.equalsIgnoreCase("view") && this.tradeLicense.getState().getValue().contains("Commissioner approved") && !this.tradeLicense.isPaid() && !this.workFlowAction.equalsIgnoreCase("Reject")) {
            this.prepareNewForm();
            ValidationError vr = new ValidationError("license.fee.notcollected", "license.fee.notcollected");
            throw new ValidationException(Arrays.asList(vr));
        }
        return super.approve();
    }

    @SkipValidation
    @Action(value="/newtradelicense/newTradeLicense-beforeRenew")
    public String beforeRenew() throws IOException {
        this.prepareNewForm();
        this.documentTypes = this.tradeLicenseService.getDocumentTypesByApplicationType(ApplicationType.RENEW);
        if (this.tradeLicense.hasState() && !this.tradeLicense.transitionCompleted()) {
            ServletActionContext.getResponse().setContentType("text/html");
            ServletActionContext.getResponse().getWriter().write("<center style='color:red;font-weight:bolder'>Renewal workflow is in progress !</center>");
            return null;
        }
        if (!this.tradeLicense.hasState() || this.tradeLicense.hasState() && this.tradeLicense.getCurrentState().isEnded()) {
            this.currentState = "";
        }
        this.tradeLicense.setNewWorkflow(true);
        this.renewAppType = "Renew";
        return super.beforeRenew();
    }

    @ValidationErrorPageExt(action="beforeRenew", makeCall=true, toMethod="prepareRenew")
    @Action(value="/newtradelicense/newTradeLicense-renewal")
    public String renew() {
        return super.renew();
    }

    public void prepareRenew() {
        this.prepareNewForm();
    }

    public void prepareNewForm() {
        super.prepareNewForm();
        if (this.license() != null && this.license().getId() != null) {
            this.tradeLicense = (TradeLicense)this.tradeLicenseService.getLicenseById(this.license().getId());
        }
        this.documentTypes = this.tradeLicenseService.getDocumentTypesByApplicationType(ApplicationType.NEW);
        this.setOwnerShipTypeMap(Constants.getOwnershipTypes());
        List localityList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("locality", "LOCATION");
        this.addDropdownData("localityList", localityList);
        this.addDropdownData("tradeTypeList", this.tradeLicenseService.getAllNatureOfBusinesses());
        this.addDropdownData("categoryList", this.licenseCategoryService.getCategories());
        this.addDropdownData("uomList", this.unitOfMeasurementService.getAllActiveUOM());
        this.addDropdownData("subCategoryList", this.tradeLicense.getCategory() == null ? Collections.emptyList() : this.licenseSubCategoryService.getSubCategoriesByCategory(this.tradeLicense.getCategory().getId()));
        if (this.license() != null && this.license().getAgreementDate() != null) {
            this.setShowAgreementDtl(true);
        }
    }

    public License getModel() {
        return this.tradeLicense;
    }

    public WorkflowBean getWorkflowBean() {
        return this.workflowBean;
    }

    public void setWorkflowBean(WorkflowBean workflowBean) {
        this.workflowBean = workflowBean;
    }

    protected TradeLicense license() {
        return this.tradeLicense;
    }

    protected AbstractLicenseService<TradeLicense> licenseService() {
        return this.tradeLicenseService;
    }

    public List<LicenseDocumentType> getDocumentTypes() {
        return this.documentTypes;
    }

    public void setDocumentTypes(List<LicenseDocumentType> documentTypes) {
        this.documentTypes = documentTypes;
    }

    public Map<String, String> getOwnerShipTypeMap() {
        return this.ownerShipTypeMap;
    }

    public void setOwnerShipTypeMap(Map<String, String> ownerShipTypeMap) {
        this.ownerShipTypeMap = ownerShipTypeMap;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getAdditionalRule() {
        if (this.tradeLicense.isNewWorkflow()) {
            if (!this.securityUtils.currentUserIsEmployee()) {
                return "Renew".equals(this.renewAppType) ? "CSCOPERATORRENEWLICENSE" : "CSCOPERATORNEWLICENSE";
            }
            if (this.license().isCollectionPending()) {
                return this.tradeLicense.isNewApplication() ? "NEWLICENSECOLLECTION" : "RENEWLICENSECOLLECTION";
            }
            if ("Renew".equals(this.renewAppType) || this.tradeLicense != null && this.tradeLicense.isReNewApplication()) {
                return "RENEWLICENSE";
            }
            return "NEWLICENSE";
        }
        if ("Renew".equals(this.renewAppType) || this.tradeLicense != null && this.tradeLicense.isReNewApplication()) {
            return "RENEWTRADELICENSE";
        }
        return "NEWTRADELICENSE";
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void prepareSave() {
        this.tradeLicense.setId((Long)this.getSession().get("model.id"));
        this.prepareNewForm();
    }

    @ValidationErrorPage(value="new")
    @Action(value="/newtradelicense/newTradeLicense-save")
    public String save() {
        this.tradeLicenseService.save((License)this.tradeLicense);
        this.addActionMessage(this.getText("license.saved.succesful"));
        return "message";
    }

    public void prepareApprove() {
        this.tradeLicense.setId((Long)this.getSession().get("model.id"));
        this.prepareNewForm();
    }
}

