/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.actions;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.Installment;
import org.egov.demand.model.EgDemandDetails;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.PositionMasterService;
import org.egov.eis.web.actions.workflow.GenericWorkFlowAction;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.persistence.entity.enums.UserType;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.viewer.ReportViewerUtil;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.NumberUtil;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.egov.tl.entity.License;
import org.egov.tl.entity.LicenseCategory;
import org.egov.tl.entity.LicenseDemand;
import org.egov.tl.entity.LicenseDocument;
import org.egov.tl.entity.LicenseSubCategory;
import org.egov.tl.entity.NatureOfBusiness;
import org.egov.tl.entity.TradeLicense;
import org.egov.tl.entity.WorkflowBean;
import org.egov.tl.service.AbstractLicenseService;
import org.egov.tl.service.FeeTypeService;
import org.egov.tl.service.LicenseApplicationService;
import org.egov.tl.service.LicenseCategoryService;
import org.egov.tl.service.LicenseSubCategoryService;
import org.egov.tl.service.ProcessOwnerReassignmentService;
import org.egov.tl.service.TradeLicenseService;
import org.egov.tl.service.TradeLicenseSmsAndEmailService;
import org.egov.tl.service.UnitOfMeasurementService;
import org.egov.tl.utils.LicenseUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name={"collection"}, type="redirectAction", location="licenseBillCollect", params={"namespace", "/integration", "method", "renew"}), @Result(name={"tl_approve"}, type="redirectAction", location="viewTradeLicense", params={"namespace", "/viewtradelicense", "method", "showForApproval"}), @Result(name={"tl_generateCertificate"}, type="redirectAction", location="../viewtradelicense/viewTradeLicense-generateCertificate"), @Result(name={"approve"}, location="newTradeLicense-new.jsp"), @Result(name={"report"}, location="newTradeLicense-report.jsp"), @Result(name={"digitalSignatureRedirection"}, location="newTradeLicense-digitalSignatureRedirection.jsp"), @Result(name={"meesevaAck"}, location="/meeseva/generatereceipt", type="redirect", params={"prependServletContext", "false", "transactionServiceNumber", "${applicationNo}"})})
public abstract class BaseLicenseAction<T extends License>
extends GenericWorkFlowAction {
    private static final long serialVersionUID = 1L;
    private static final String WF_ITEM_PROCESSED = "wf.item.processed";
    private static final String MESSAGE = "message";
    protected transient WorkflowBean workflowBean = new WorkflowBean();
    protected transient List<String> buildingTypeList;
    protected transient String roleName;
    protected transient String reportId;
    protected transient List<HashMap<String, Object>> licenseHistory = new ArrayList();
    protected transient boolean showAgreementDtl;
    protected transient String applicationNo;
    protected List<LicenseDocument> licenseDocument = new ArrayList();
    @Autowired
    protected transient LicenseUtils licenseUtils;
    @Autowired
    protected transient PositionMasterService positionMasterService;
    @Autowired
    protected transient SecurityUtils securityUtils;
    @Autowired
    protected transient AssignmentService assignmentService;
    @Autowired
    protected transient BoundaryService boundaryService;
    @Autowired
    @Qualifier(value="licenseCategoryService")
    protected transient LicenseCategoryService licenseCategoryService;
    @Autowired
    @Qualifier(value="licenseSubCategoryService")
    protected transient LicenseSubCategoryService licenseSubCategoryService;
    @Autowired
    @Qualifier(value="unitOfMeasurementService")
    protected transient UnitOfMeasurementService unitOfMeasurementService;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected transient FileStoreService fileStoreService;
    @Autowired
    protected transient ReportViewerUtil reportViewerUtil;
    private transient String fileStoreIds;
    private transient String ulbCode;
    private transient String signedFileStoreId;
    private transient Long feeTypeId;
    private transient boolean hasCscOperatorRole;
    private transient TradeLicenseSmsAndEmailService tradeLicenseSmsAndEmailService;
    @Autowired
    private transient TradeLicenseService tradeLicenseService;
    @Autowired
    @Qualifier(value="feeTypeService")
    private transient FeeTypeService feeTypeService;
    @Autowired
    private transient ProcessOwnerReassignmentService processOwnerReassignmentService;
    @Autowired
    private LicenseApplicationService licenseApplicationService;

    public BaseLicenseAction() {
        this.addRelatedEntity("boundary", Boundary.class);
        this.addRelatedEntity("parentBoundary", Boundary.class);
        this.addRelatedEntity("licensee.boundary", Boundary.class);
        this.addRelatedEntity("natureOfBusiness", NatureOfBusiness.class);
        this.addRelatedEntity("category", LicenseCategory.class);
        this.addRelatedEntity("tradeName", LicenseSubCategory.class);
    }

    protected abstract T license();

    protected abstract AbstractLicenseService<T> licenseService();

    @ValidationErrorPage(value="new")
    public String create(T license) {
        this.addNewDocuments();
        this.populateWorkflowBean();
        if (this.tradeLicenseService.currentUserIsMeeseva().booleanValue()) {
            license.setApplicationNumber(this.getApplicationNo());
            this.licenseApplicationService.createWithMeseva((TradeLicense)license, this.workflowBean);
        } else {
            this.licenseApplicationService.create((TradeLicense)license, this.workflowBean);
            this.addActionMessage(this.getText("license.submission.succesful") + this.license().getApplicationNumber());
            this.setHasCscOperatorRole(this.securityUtils.getCurrentUser().getRoles().toString().contains("CSC Operator"));
        }
        return this.tradeLicenseService.currentUserIsMeeseva() != false ? "meesevaAck" : "acknowledgement";
    }

    public String approve() {
        this.populateWorkflowBean();
        if ("Preview".equals(this.workFlowAction)) {
            return this.redirectToPrintCertificate();
        }
        if ("Sign".equals(this.workFlowAction)) {
            return this.digitalSignRedirection();
        }
        if (!this.license().isNewWorkflow()) {
            this.tradeLicenseService.updateStatusInWorkFlowProgress((TradeLicense)this.license(), this.workFlowAction);
            if (!"Generate Certificate".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
                WorkFlowMatrix wfmatrix = this.tradeLicenseService.getWorkFlowMatrixApi(this.license(), this.workflowBean);
                if (!this.license().getCurrentState().getValue().equals(wfmatrix.getCurrentState())) {
                    this.addActionMessage(this.getText(WF_ITEM_PROCESSED));
                    return MESSAGE;
                }
            }
            if ("Generate Certificate".equalsIgnoreCase(this.workflowBean.getWorkFlowAction()) && "END".equalsIgnoreCase(this.license().getCurrentState().getValue())) {
                this.addActionMessage(this.getText(WF_ITEM_PROCESSED));
                return MESSAGE;
            }
            this.processWorkflow();
            this.addNewDocuments();
            this.tradeLicenseService.updateTradeLicense((TradeLicense)this.license(), this.workflowBean);
            if ("Generate Certificate".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
                return "tl_generateCertificate";
            }
            return MESSAGE;
        }
        WorkFlowMatrix wfmatrix = this.licenseApplicationService.getWorkflowAPI((TradeLicense)this.license(), this.workflowBean);
        if (!this.license().getCurrentState().getValue().equals(wfmatrix.getCurrentState())) {
            this.addActionMessage(this.getText(WF_ITEM_PROCESSED));
            return MESSAGE;
        }
        if ("Generate Provisional Certificate".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
            this.reportId = this.reportViewerUtil.addReportToTempCache(this.tradeLicenseService.generateLicenseCertificate(this.license(), true));
            return "report";
        }
        this.licenseApplicationService.updateTradeLicense((TradeLicense)this.license(), this.workflowBean);
        this.successMessage();
        if ("Generate Certificate".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
            return "tl_generateCertificate";
        }
        return MESSAGE;
    }

    private String redirectToPrintCertificate() {
        this.reportId = this.reportViewerUtil.addReportToTempCache(this.tradeLicenseService.generateLicenseCertificate(this.license(), false));
        return "report";
    }

    private String digitalSignRedirection() {
        ReportOutput reportOutput = this.tradeLicenseService.generateLicenseCertificate(this.license(), false);
        if (reportOutput != null) {
            String fileName = "SN/" + this.license().getApplicationNumber() + ".pdf";
            ByteArrayInputStream fileStream = new ByteArrayInputStream(reportOutput.getReportOutputData());
            FileStoreMapper fileStore = this.fileStoreService.store((InputStream)fileStream, fileName, "application/pdf", "TL");
            this.license().setDigiSignedCertFileStoreId(fileStore.getFileStoreId());
            this.licenseService().save(this.license());
            this.fileStoreIds = fileStore.getFileStoreId();
            this.ulbCode = ApplicationThreadLocals.getCityCode();
            this.applicationNo = this.license().getApplicationNumber();
        }
        return "digitalSignatureRedirection";
    }

    protected void populateWorkflowBean() {
        this.workflowBean.setApproverPositionId(this.approverPositionId);
        this.workflowBean.setApproverComments(this.approverComments);
        this.workflowBean.setWorkFlowAction(this.workFlowAction);
        this.workflowBean.setCurrentState(this.currentState);
        this.workflowBean.setAdditionaRule(this.additionalRule);
        this.workflowBean.setCurrentDesignation(this.currentDesignation);
    }

    @SkipValidation
    public String beforeRenew() throws IOException {
        return "beforeRenew";
    }

    @SkipValidation
    public String renew() {
        this.addNewDocuments();
        this.populateWorkflowBean();
        if (this.tradeLicenseService.currentUserIsMeeseva().booleanValue()) {
            this.license().setApplicationNumber(this.getApplicationNo());
            this.licenseApplicationService.renewWithMeeseva((TradeLicense)this.license(), this.workflowBean);
        } else {
            this.licenseApplicationService.renew((TradeLicense)this.license(), this.workflowBean);
            this.addActionMessage(this.getText("license.renew.submission.succesful") + " " + this.license().getApplicationNumber());
            this.setHasCscOperatorRole(this.securityUtils.getCurrentUser().getRoles().toString().contains("CSC Operator"));
        }
        return this.tradeLicenseService.currentUserIsMeeseva() != false ? "meesevaAck" : "acknowledgement";
    }

    @SkipValidation
    public String enterExistingForm() {
        return "new";
    }

    public void prepareEnterExistingForm() {
        this.prepareNewForm();
    }

    public void initiateWorkFlowForLicense() {
        Position position = this.positionMasterService.getCurrentPositionForUser(ApplicationThreadLocals.getUserId());
        if (position != null) {
            this.addActionMessage(this.getText("license.saved.in.inbox"));
        }
    }

    public List<String> getBuildingTypeList() {
        return this.buildingTypeList;
    }

    public void setBuildingTypeList(List<String> buildingTypeList) {
        this.buildingTypeList = buildingTypeList;
    }

    public License getModel() {
        return this.license();
    }

    @SkipValidation
    public String newForm() {
        return "new";
    }

    public void prepareCreate() {
        this.prepareNewForm();
    }

    public void prepareNewForm() {
        this.prepare();
        this.buildingTypeList = new ArrayList();
        this.buildingTypeList.add("Own Building");
        this.buildingTypeList.add("Rental");
        this.addDropdownData("areaListLicense", Collections.emptyList());
        this.addDropdownData("areaListLicense", Collections.emptyList());
        this.addDropdownData("divisionListLicense", Collections.emptyList());
        this.addDropdownData("divisionListLicensee", Collections.emptyList());
        this.addDropdownData("tradeNameList", this.licenseUtils.getAllTradeNames(this.getModel().getClass().getSimpleName()));
        this.setupWorkflowDetails();
        this.feeTypeId = this.feeTypeService.findByName("License Fee").getId();
    }

    public void prepareShowForApproval() {
        this.prepareNewForm();
    }

    public void processWorkflow() {
        this.licenseService().transitionWorkFlow(this.license(), this.workflowBean);
        this.successMessage();
    }

    private void successMessage() {
        if ("Approve".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
            this.addActionMessage(this.getText("license.approved.success"));
        } else if ("Forward".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
            List assignments = this.assignmentService.getAssignmentsForPosition(this.workflowBean.getApproverPositionId());
            String nextDesgn = !assignments.isEmpty() ? ((Assignment)assignments.get(0)).getDesignation().getName() : "";
            String userName = !assignments.isEmpty() ? ((Assignment)assignments.get(0)).getEmployee().getName() : "";
            this.addActionMessage(this.getText("license.sent") + " " + nextDesgn + " - " + userName);
        } else if ("Reject".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
            this.rejectActionMessage();
        } else if ("Cancel".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
            this.addActionMessage(this.getText("license.rejected") + this.license().getApplicationNumber());
        } else if ("GeneratedCertificate".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
            this.addActionMessage(this.getText("license.certifiacte.print.complete.recorded"));
        }
    }

    private void rejectActionMessage() {
        if (!this.license().isNewWorkflow()) {
            User user = this.getInitiatorUserObj();
            if (user != null && !UserType.EMPLOYEE.equals((Object)user.getType())) {
                List assignments = this.assignmentService.getAssignmentsForPosition(((Position)this.license().getState().getInitiatorPosition()).getId());
                user = ((Assignment)assignments.get(0)).getEmployee();
            }
            if (this.license().getState().getValue().contains("Rejected")) {
                Position creatorPosition = (Position)this.license().getState().getInitiatorPosition();
                this.addActionMessage(this.getText("license.rejectedfirst") + " " + creatorPosition.getDeptDesig().getDesignation().getName() + " - " + (user != null ? user.getName() : ""));
            } else {
                this.addActionMessage(this.getText("license.rejected") + this.license().getApplicationNumber());
            }
        } else if ("Reject".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
            Position currentOwner = (Position)this.license().currentAssignee();
            Designation designation = currentOwner.getDeptDesig().getDesignation();
            List assignments = this.assignmentService.getAssignmentsForPosition(currentOwner.getId());
            String userName = !assignments.isEmpty() ? ((Assignment)assignments.get(0)).getEmployee().getName() : "";
            this.addActionMessage(this.getText("license.rejectedfirst") + " " + designation.getName() + " - " + userName);
        } else {
            this.addActionMessage(this.getText("license.rejected") + this.license().getApplicationNumber());
        }
    }

    private User getInitiatorUserObj() {
        User user = null;
        for (StateHistory state : this.license().getState().getHistory()) {
            if (!state.getValue().contains("License Created")) continue;
            user = state.getCreatedBy();
            break;
        }
        return user;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    @SkipValidation
    public String showForApproval() throws IOException {
        this.getSession().put("model.id", this.license().getId());
        String result = "approve";
        this.setRoleName(this.securityUtils.getCurrentUser().getRoles().toString());
        if (this.license().isNewApplication()) {
            result = this.license().getState().getValue().contains("Generate Certificate") ? "tl_generateCertificate" : "approve";
        }
        return result;
    }

    public void setupWorkflowDetails() {
        this.workflowBean.setDepartmentList(this.licenseUtils.getAllDepartments());
        this.workflowBean.setDesignationList(Collections.emptyList());
        this.workflowBean.setAppoverUserList(Collections.emptyList());
    }

    public Boolean reassignEnabled() {
        return this.processOwnerReassignmentService.reassignmentEnabled();
    }

    public LicenseDemand getCurrentYearDemand() {
        return this.license().getLicenseDemand();
    }

    public String getPayableAmountInWords() {
        return NumberUtil.amountInWords((BigDecimal)this.license().getTotalBalance());
    }

    public String getCollectedDemandAmountInWords() {
        return NumberUtil.amountInWords((BigDecimal)this.license().getLicenseDemand().getAmtCollected());
    }

    public boolean isCurrent(EgDemandDetails dd) {
        boolean isCurrent = false;
        Installment currInstallment = this.licenseUtils.getCurrInstallment(dd.getEgDemandReason().getEgDemandReasonMaster().getEgModule());
        if (currInstallment.getId().intValue() == dd.getEgDemandReason().getEgInstallmentMaster().getId().intValue()) {
            isCurrent = true;
        }
        return isCurrent;
    }

    public Map<String, Map<String, BigDecimal>> getOutstandingFee() {
        return this.licenseService().getOutstandingFee(this.license());
    }

    public boolean isCitizen() {
        return this.securityUtils.currentUserType().equals((Object)UserType.CITIZEN);
    }

    public String getReportId() {
        return this.reportId;
    }

    public Long getFeeTypeId() {
        return this.feeTypeId;
    }

    public void setFeeTypeId(Long feeTypeId) {
        this.feeTypeId = feeTypeId;
    }

    public boolean isShowAgreementDtl() {
        return this.showAgreementDtl;
    }

    public void setShowAgreementDtl(boolean showAgreementDtl) {
        this.showAgreementDtl = showAgreementDtl;
    }

    public String getFileStoreIds() {
        return this.fileStoreIds;
    }

    public void setFileStoreIds(String fileStoreIds) {
        this.fileStoreIds = fileStoreIds;
    }

    public String getUlbCode() {
        return this.ulbCode;
    }

    public void setUlbCode(String ulbCode) {
        this.ulbCode = ulbCode;
    }

    public String getSignedFileStoreId() {
        return this.signedFileStoreId;
    }

    public void setSignedFileStoreId(String signedFileStoreId) {
        this.signedFileStoreId = signedFileStoreId;
    }

    public TradeLicenseSmsAndEmailService getTradeLicenseSmsAndEmailService() {
        return this.tradeLicenseSmsAndEmailService;
    }

    public void setTradeLicenseSmsAndEmailService(TradeLicenseSmsAndEmailService tradeLicenseSmsAndEmailService) {
        this.tradeLicenseSmsAndEmailService = tradeLicenseSmsAndEmailService;
    }

    public String getApplicationNo() {
        return this.applicationNo;
    }

    public void setApplicationNo(String applicationNo) {
        this.applicationNo = applicationNo;
    }

    public boolean isHasCscOperatorRole() {
        return this.hasCscOperatorRole;
    }

    public void setHasCscOperatorRole(boolean hasCscOperatorRole) {
        this.hasCscOperatorRole = hasCscOperatorRole;
    }

    public List<HashMap<String, Object>> getLicenseHistory() {
        return this.licenseHistory;
    }

    public void setLicenseHistory(List<HashMap<String, Object>> licenseHistory) {
        this.licenseHistory = licenseHistory;
    }

    public List<LicenseDocument> getLicenseDocument() {
        return this.licenseDocument;
    }

    public void setLicenseDocument(List<LicenseDocument> licenseDocument) {
        this.licenseDocument = licenseDocument;
    }

    public void addNewDocuments() {
        this.licenseDocument.removeIf(document -> document.getUploadsFileName().isEmpty());
        this.licenseDocument.forEach(document -> document.setType(this.tradeLicenseService.getLicenseDocumentType(document.getType().getId())));
        this.license().getDocuments().addAll(this.licenseDocument);
    }

    public List<String> getValidActions() {
        List<Object> validActions = new ArrayList();
        if (null == this.getModel() || null == this.getModel().getId() || this.getModel().getCurrentState() == null || this.getModel().getCurrentState().getValue().endsWith("NEW") || this.getModel() != null && this.getModel().getCurrentState() != null && this.getModel().getCurrentState().isEnded()) {
            validActions = Arrays.asList("Save");
        } else if (this.getModel().hasState()) {
            if (this.getModel().isNewWorkflow()) {
                validActions.addAll(this.customizedWorkFlowService.getNextValidActions(this.getModel().getStateType(), this.getWorkFlowDepartment(), this.getAmountRule(), this.getAdditionalRule(), this.getModel().getCurrentState().getValue(), this.getPendingActions(), this.getModel().getCreatedDate(), "%" + ((Position)this.license().getCurrentState().getOwnerPosition()).getDeptDesig().getDesignation().getName() + "%"));
            } else {
                validActions.addAll(super.getValidActions());
            }
        }
        validActions.removeIf(validAction -> "Reassign".equals(validAction) && this.getModel().getState().getCreatedBy().getId().equals(ApplicationThreadLocals.getUserId()));
        return validActions;
    }

    public String getCurrentDesignation() {
        return this.license().hasState() ? "%" + ((Position)this.license().getCurrentState().getOwnerPosition()).getDeptDesig().getDesignation().getName() + "%" : "";
    }

    public Boolean forwardEnabled() {
        if (this.getModel() == null || this.getModel().getCurrentState() == null) {
            return false;
        }
        return this.customizedWorkFlowService.getWfMatrix(this.getModel().getStateType(), this.getWorkFlowDepartment(), this.getAmountRule(), this.getAdditionalRule(), this.getModel().getCurrentState().getValue(), this.getPendingActions(), new Date(), this.getCurrentDesignation()).isForwardEnabled();
    }

    public String getEnabledFields() {
        if (this.getModel().hasState()) {
            WorkFlowMatrix workFlowMatrix = this.customizedWorkFlowService.getWfMatrix(this.getModel().getStateType(), this.getWorkFlowDepartment(), this.getAmountRule(), this.getAdditionalRule(), this.getModel().getCurrentState().getValue(), this.getPendingActions(), this.getModel().getCreatedDate(), "%" + ((Position)this.license().getCurrentState().getOwnerPosition()).getDeptDesig().getDesignation().getName() + "%");
            return workFlowMatrix.getEnableFields();
        }
        return "all";
    }
}

