/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.report;

import java.util.Collection;
import java.util.HashMap;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.web.support.ui.DataTable;
import org.egov.infra.web.utils.WebUtils;
import org.egov.tl.entity.dto.DCBReportSearchRequest;
import org.egov.tl.entity.view.DCBReportResult;
import org.egov.tl.service.DCBReportService;
import org.egov.tl.web.response.adaptor.DCBReportResponseAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report/dcb"})
public class DCBReportController {
    private static final String LICENSE = "license";
    private static final String REPORT_TYPE_ATTRIB_NAME = "reportType";
    @Autowired
    private DCBReportService dCBReportService;
    @Autowired
    private ReportService reportService;

    @ModelAttribute(value="dCBReportResult")
    public DCBReportResult dCBReportResultModel() {
        return new DCBReportResult();
    }

    @GetMapping(value={"search"})
    public String dcbSearchForm(Model model) {
        model.addAttribute("mode", (Object)LICENSE);
        model.addAttribute(REPORT_TYPE_ATTRIB_NAME, (Object)LICENSE);
        return "dCBReport-search";
    }

    @PostMapping(value={"search"}, produces={"text/plain"})
    @ResponseBody
    public String searchDCBReport(DCBReportSearchRequest searchRequest) {
        return new DataTable(this.dCBReportService.pagedDCBRecords(searchRequest), (long)searchRequest.draw()).toJson(DCBReportResponseAdaptor.class);
    }

    @GetMapping(value={"grand-total"})
    @ResponseBody
    public Object[] dcbGrandTotal(DCBReportSearchRequest searchRequest) {
        return this.dCBReportService.dcbGrandTotal(searchRequest);
    }

    @GetMapping(value={"download"})
    @ResponseBody
    public ResponseEntity<InputStreamResource> dcbReportDownload(DCBReportSearchRequest searchRequest) {
        HashMap responseParams = new HashMap();
        ReportRequest reportRequest = new ReportRequest("tl_dcb_report", (Collection)this.dCBReportService.getAllDCBRecords(searchRequest), responseParams);
        reportRequest.setReportFormat(searchRequest.getPrintFormat());
        reportRequest.setReportName("dcb_report");
        return WebUtils.reportToResponseEntity((ReportRequest)reportRequest, (ReportOutput)this.reportService.createReport(reportRequest));
    }
}

