/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.legacy;

import java.io.IOException;
import javax.validation.Valid;
import javax.validation.ValidationException;
import org.egov.tl.entity.License;
import org.egov.tl.entity.TradeLicense;
import org.egov.tl.web.controller.legacy.LegacyLicenseController;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/legacylicense"})
public class ModifyLegacyLicenseController
extends LegacyLicenseController {
    private static final String UPDATE_LEGACY_FORM = "updateform-legacylicense";

    @ModelAttribute(value="tradeLicense")
    public TradeLicense tradeLicense(@PathVariable Long id) {
        return (TradeLicense)this.tradeLicenseService.getLicenseById(id);
    }

    @GetMapping(value={"/update/{id}"})
    public String update(@ModelAttribute TradeLicense tradeLicense, Model model) {
        model.addAttribute("legacyInstallmentwiseFees", (Object)this.legacyService.legacyInstallmentwiseFees(tradeLicense));
        model.addAttribute("legacyFeePayStatus", (Object)this.legacyService.legacyFeePayStatus(tradeLicense));
        model.addAttribute("outstandingFee", (Object)this.tradeLicenseService.getOutstandingFee((License)tradeLicense));
        return UPDATE_LEGACY_FORM;
    }

    @PostMapping(value={"/update/{id}"})
    public String update(@Valid @ModelAttribute TradeLicense tradeLicense, BindingResult errors, @RequestParam(value="files") MultipartFile[] files, Model model) throws IOException {
        if (errors.hasErrors()) {
            model.addAttribute("legacyInstallmentwiseFees", (Object)this.legacyService.legacyInstallmentwiseFees(tradeLicense));
            model.addAttribute("legacyFeePayStatus", (Object)this.legacyService.legacyFeePayStatus(tradeLicense));
            model.addAttribute("outstandingFee", (Object)this.tradeLicenseService.getOutstandingFee((License)tradeLicense));
            return UPDATE_LEGACY_FORM;
        }
        try {
            this.legacyService.storeDocument((License)tradeLicense, files);
        }
        catch (ValidationException e) {
            errors.rejectValue("files", e.getMessage());
            return UPDATE_LEGACY_FORM;
        }
        this.legacyService.updateLegacy(tradeLicense);
        return "redirect:/legacylicense/view/" + tradeLicense.getApplicationNumber();
    }
}

