/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.legacy;

import java.io.IOException;
import java.util.Map;
import javax.validation.Valid;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.tl.entity.License;
import org.egov.tl.entity.TradeLicense;
import org.egov.tl.web.controller.legacy.LegacyLicenseController;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/legacylicense"})
public class CreateLegacyLicenseController
extends LegacyLicenseController {
    private static final String CREATE_LEGACY_LICENSE = "create-legacylicense";

    @ModelAttribute(value="tradeLicense")
    public TradeLicense tradeLicense() {
        return new TradeLicense();
    }

    @ModelAttribute(value="legacyFeePayStatus")
    public Map<Integer, Boolean> legacyFeePayStatus() {
        return this.legacyService.legacyFeePayStatusForCreate();
    }

    @ModelAttribute(value="legacyInstallmentwiseFees")
    public Map<Integer, Integer> legacyInstallmentwiseFees() {
        return this.legacyService.legacyInstallmentwiseFeesForCreate();
    }

    @GetMapping(value={"/create"})
    public String create() {
        return CREATE_LEGACY_LICENSE;
    }

    @PostMapping(value={"/create"})
    public String create(@Valid TradeLicense tradeLicense, BindingResult binding, @RequestParam(value="files") MultipartFile[] files) throws IOException {
        if (binding.hasErrors()) {
            return CREATE_LEGACY_LICENSE;
        }
        try {
            this.legacyService.storeDocument((License)tradeLicense, files);
            this.legacyService.createLegacy(tradeLicense);
        }
        catch (ValidationException e) {
            binding.reject(((ValidationError)e.getErrors().get(0)).getKey());
            return CREATE_LEGACY_LICENSE;
        }
        return "redirect:/legacylicense/view/" + tradeLicense.getApplicationNumber();
    }

    @GetMapping(value={"/old-licenseno-is-unique"}, produces={"application/json"})
    @ResponseBody
    public Boolean checkOldLicenseNumber(@RequestParam String oldLicenseNumber) {
        return this.licenseRepository.findByOldLicenseNumber(oldLicenseNumber) != null;
    }
}

