/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller;

import javax.validation.Valid;
import org.egov.tl.entity.LicenseDocumentType;
import org.egov.tl.entity.enums.ApplicationType;
import org.egov.tl.service.DocumentTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/documenttype/edit/{id}"})
public class DocumentEditController {
    @Autowired
    private final DocumentTypeService documentTypeService;

    @Autowired
    public DocumentEditController(DocumentTypeService documentTypeService) {
        this.documentTypeService = documentTypeService;
    }

    @ModelAttribute
    public void getDocumentType(@PathVariable Long id, Model model) {
        model.addAttribute("documenttype", (Object)this.documentTypeService.getDocumentTypeById(id));
        model.addAttribute("applicationTypes", (Object)ApplicationType.values());
    }

    @RequestMapping(method={RequestMethod.GET})
    public String documentTypeEdit(@PathVariable Long id) {
        return "document-edit";
    }

    @RequestMapping(method={RequestMethod.POST})
    public String documentTypeEdit(@Valid @ModelAttribute(value="documenttype") LicenseDocumentType documenttype, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            model.addAttribute("message", (Object)"msg.edit.error");
            return "document-edit";
        }
        this.documentTypeService.update(documenttype);
        redirectAttrs.addFlashAttribute("documenttype", (Object)documenttype);
        redirectAttrs.addFlashAttribute("message", (Object)"msg.update.success");
        redirectAttrs.addFlashAttribute("heading", (Object)"msg.heading.success");
        return "redirect:/documenttype/view/" + documenttype.getId();
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String documentTypeView(@PathVariable(value="id") Long id, Model model) {
        model.addAttribute("documenttype", (Object)this.documentTypeService.getDocumentTypeById(id));
        return "document-view";
    }
}

