/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.response.adaptor;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.egov.tl.entity.FeeMatrix;
import org.egov.tl.entity.FeeMatrixDetail;

public class FeeMatrixResponseAdaptor
implements JsonSerializer<FeeMatrix> {
    public JsonElement serialize(FeeMatrix feeMatrix, Type type, JsonSerializationContext jsc) {
        JsonObject feeMatrixResponse = new JsonObject();
        if (feeMatrix != null) {
            feeMatrixResponse.addProperty("id", (Number)feeMatrix.getId());
            feeMatrixResponse.addProperty("licenseCategory", feeMatrix.getLicenseCategory().getName());
            feeMatrixResponse.addProperty("subCategory", feeMatrix.getSubCategory().getName());
            feeMatrixResponse.addProperty("feeType", feeMatrix.getFeeType().getName());
            feeMatrixResponse.addProperty("financialYear", feeMatrix.getFinancialYear().getFinYearRange());
            feeMatrixResponse.addProperty("natureOfBussiness", feeMatrix.getNatureOfBusiness().getName());
            feeMatrixResponse.addProperty("licenseAppType", feeMatrix.getLicenseAppType().getName());
            JsonArray details = new JsonArray();
            for (FeeMatrixDetail detail : feeMatrix.getFeeMatrixDetail()) {
                JsonObject detailJson = new JsonObject();
                detailJson.addProperty("uomFrom", (Number)detail.getUomFrom());
                detailJson.addProperty("uomTo", (Number)detail.getUomTo());
                detailJson.addProperty("amount", (Number)detail.getAmount());
                details.add((JsonElement)detailJson);
            }
            feeMatrixResponse.add("details", (JsonElement)details);
        }
        return feeMatrixResponse;
    }
}

