/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.payment;

import java.io.IOException;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.utils.JsonUtils;
import org.egov.tl.entity.License;
import org.egov.tl.entity.dto.DCBReportResult;
import org.egov.tl.service.DCBReportService;
import org.egov.tl.service.TradeLicenseService;
import org.egov.tl.web.response.adaptor.DCBReportResponseAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class ViewDCBController {
    private static final String LICENSE = "license";
    @Autowired
    private TradeLicenseService tradeLicenseService;
    @Autowired
    private DCBReportService dCBReportService;
    private License licenseObj;

    @RequestMapping(value={"/public/view-license-dcb/{id}"}, method={RequestMethod.GET})
    public String search(@PathVariable Long id, Model model) throws IOException {
        this.licenseObj = this.tradeLicenseService.getLicenseById(id);
        model.addAttribute(LICENSE, (Object)this.licenseObj);
        model.addAttribute("dcbreport", (Object)JsonUtils.toJSON((Collection)this.dCBReportService.generateReportResult(this.licenseObj.getLicenseNumber(), StringUtils.defaultString((String)LICENSE), StringUtils.defaultString((String)LICENSE)), DCBReportResult.class, DCBReportResponseAdaptor.class));
        return "view-license-dcb";
    }

    public License getLicenseObj() {
        return this.licenseObj;
    }

    public void setLicenseObj(License licenseObj) {
        this.licenseObj = licenseObj;
    }
}

