/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.payment;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.List;
import org.egov.infra.utils.JsonUtils;
import org.egov.tl.entity.License;
import org.egov.tl.entity.dto.OnlineSearchForm;
import org.egov.tl.service.TradeLicenseService;
import org.egov.tl.service.integration.LicenseBillService;
import org.egov.tl.web.response.adaptor.OnlineSearchTradeResultHelperAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class LicenseBillOnlinePaymentController {
    @Autowired
    private LicenseBillService licenseBillService;
    @Autowired
    private TradeLicenseService tradeLicenseService;

    @ModelAttribute(value="onlineSearchForm")
    public OnlineSearchForm onlineSearchForm() {
        return new OnlineSearchForm();
    }

    @RequestMapping(value={"/public/licenseonlinepayment-form/{id}"}, method={RequestMethod.GET})
    public String execute(@PathVariable Long id, Model model) throws IOException {
        License license = this.tradeLicenseService.getLicenseById(id);
        if (license.isPaid()) {
            model.addAttribute("paymentdone", (Object)"License Fee already collected");
            return "license-onlinepayment";
        }
        model.addAttribute("collectXML", (Object)URLEncoder.encode(this.licenseBillService.createLicenseBillXML(license), "UTF-8"));
        return "license-onlinepayment";
    }

    @RequestMapping(value={"/public/search/searchlicensepayment-form"}, method={RequestMethod.GET})
    public String searchLicenseForPayment() {
        return "searchtrade-licenseforpay";
    }

    @RequestMapping(value={"/public/search/searchtrade-search"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    public String search(@ModelAttribute OnlineSearchForm searchForm) throws IOException {
        return "{ \"data\":" + JsonUtils.toJSON((Collection)this.tradeLicenseService.onlineSearchTradeLicense(searchForm), OnlineSearchForm.class, OnlineSearchTradeResultHelperAdaptor.class) + "}";
    }

    @RequestMapping(value={"/public/search/tradeLicense"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> searchautocomplete(@RequestParam String searchParamValue, @RequestParam String searchParamType) {
        return this.tradeLicenseService.getTradeLicenseForGivenParam(searchParamValue, searchParamType);
    }
}

