/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.utils.JsonUtils;
import org.egov.tl.entity.dto.DemandnoticeForm;
import org.egov.tl.entity.dto.SearchForm;
import org.egov.tl.service.LicenseCategoryService;
import org.egov.tl.service.LicenseStatusService;
import org.egov.tl.service.TradeLicenseService;
import org.egov.tl.web.response.adaptor.DemandNoticeAdaptor;
import org.egov.tl.web.response.adaptor.SearchTradeResultHelperAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class SearchTradeController {
    @Autowired
    protected LicenseCategoryService licenseCategoryService;
    @Autowired
    private TradeLicenseService tradeLicenseService;
    @Autowired
    private LicenseStatusService licenseStatusService;
    @Autowired
    private BoundaryService boundaryService;

    @ModelAttribute(value="searchForm")
    public SearchForm searchForm() {
        return new SearchForm();
    }

    @RequestMapping(value={"/search/searchtrade-form"}, method={RequestMethod.GET})
    public String searchForm(Model model) {
        model.addAttribute("categoryList", (Object)this.licenseCategoryService.getCategories());
        model.addAttribute("subCategoryList", Collections.emptyList());
        model.addAttribute("statusList", (Object)this.licenseStatusService.findAll());
        return "searchtrade-license";
    }

    @RequestMapping(value={"/search/searchtrade-search"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    public String search(@ModelAttribute SearchForm searchForm) throws IOException {
        return "{ \"data\":" + JsonUtils.toJSON((Collection)this.tradeLicenseService.searchTradeLicense(searchForm), SearchForm.class, SearchTradeResultHelperAdaptor.class) + "}";
    }

    @RequestMapping(value={"/search/tradeLicense"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> searchautocomplete(@RequestParam String searchParamValue, @RequestParam String searchParamType) {
        return this.tradeLicenseService.getTradeLicenseForGivenParam(searchParamValue, searchParamType);
    }

    @RequestMapping(value={"/search/demandnotice"}, method={RequestMethod.GET})
    public String searchFormforNotice(Model model) {
        model.addAttribute("demandnoticesearchForm", (Object)new DemandnoticeForm());
        model.addAttribute("categoryList", (Object)this.licenseCategoryService.getCategories());
        model.addAttribute("subCategoryList", Collections.emptyList());
        List statuslist = this.licenseStatusService.findAll();
        statuslist.remove(this.licenseStatusService.getLicenseStatusByCode("CAN"));
        model.addAttribute("statusList", (Object)statuslist);
        model.addAttribute("localityList", (Object)this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("locality", "LOCATION"));
        model.addAttribute("wardList", (Object)this.boundaryService.getBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE"));
        return "search-demandnotice";
    }

    @RequestMapping(value={"/search/demandnotice-result"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    public String searchResult(@ModelAttribute DemandnoticeForm demandnoticeForm) throws IOException {
        return "{ \"data\":" + JsonUtils.toJSON((Collection)this.tradeLicenseService.searchLicensefordemandnotice(demandnoticeForm), DemandnoticeForm.class, DemandNoticeAdaptor.class) + "}";
    }
}

