/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller;

import java.util.List;
import org.egov.tl.entity.LicenseAppType;
import org.egov.tl.entity.PenaltyRates;
import org.egov.tl.entity.dto.PenaltyForm;
import org.egov.tl.service.PenaltyRatesService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/penaltyRates"})
public class PenaltyRatesController {
    public static final String PENALTYRATE_RESULT = "penaltyRates-result";
    @Autowired
    private PenaltyRatesService penaltyRatesService;

    @ModelAttribute(value="licenseAppTypes")
    public List<LicenseAppType> licenseAppTypes() {
        return this.penaltyRatesService.findAllLicenseAppType();
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String penaltyRatesForm(@ModelAttribute PenaltyForm penaltyForm, Model model) {
        return "penaltyRates-create";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String penaltyRatesCreate(@ModelAttribute PenaltyForm penaltyForm, BindingResult bindingResult, RedirectAttributes redirectAttributes, Model model) {
        if (bindingResult.hasErrors()) {
            return PENALTYRATE_RESULT;
        }
        this.penaltyRatesService.create(penaltyForm.getPenaltyRates());
        redirectAttributes.addFlashAttribute("message", (Object)"msg.penaltyRate.created");
        return "penaltyRates-view";
    }

    @RequestMapping(value={"/view"}, method={RequestMethod.GET})
    public String searchForm(@ModelAttribute PenaltyForm penaltyForm, Model model) {
        return "penaltyRates-search";
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String search(@ModelAttribute PenaltyForm penaltyForm, BindingResult errors, Model model) {
        if (errors.hasErrors()) {
            return PENALTYRATE_RESULT;
        }
        penaltyForm.setPenaltyRatesList(this.penaltyRatesService.search(penaltyForm.getLicenseAppType().getId()));
        model.addAttribute("penaltyForm", (Object)penaltyForm);
        return PENALTYRATE_RESULT;
    }

    @RequestMapping(value={"/searchview"}, method={RequestMethod.GET})
    public String searchview(@ModelAttribute PenaltyForm penaltyForm, BindingResult errors, Model model) {
        if (errors.hasErrors()) {
            return "penaltyRates-search";
        }
        penaltyForm.setPenaltyRatesList(this.penaltyRatesService.search(penaltyForm.getLicenseAppType().getId()));
        model.addAttribute("penaltyForm", (Object)penaltyForm);
        return "penaltyRates-viewResult";
    }

    @RequestMapping(value={"/deleterow"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    public String deletepenaltyfeerow(@RequestParam Long penaltyRateId) {
        PenaltyRates penaltyRates = this.penaltyRatesService.findOne(Long.valueOf(penaltyRateId));
        if (penaltyRates != null) {
            this.penaltyRatesService.delete(penaltyRates);
        }
        return "success";
    }
}

