/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.FileUtils;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.repository.FileStoreMapperRepository;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.tl.entity.License;
import org.egov.tl.utils.LicenseUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/digitalSignature"})
public class DigitalSignatureTradeLicenseController {
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    @Qualifier(value="tradeLicenseWorkflowService")
    private SimpleWorkflowService tradeLicenseWorkflowService;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private LicenseUtils licenseUtils;
    @Autowired
    private FileStoreMapperRepository fileStoreMapperRepository;

    @RequestMapping(value={"/tradeLicense/transitionWorkflow"})
    public String transitionWorkflow(HttpServletRequest request, Model model) {
        String fileStoreIds = request.getParameter("fileStoreId");
        String[] fileStoreIdArr = fileStoreIds.split(",");
        HttpSession session = request.getSession();
        Map appNoFileStoreIdsMap = (Map)session.getAttribute("fileStoreIdApplicationNumber");
        User user = this.securityUtils.getCurrentUser();
        for (String fileStoreId : fileStoreIdArr) {
            String applicationNumber = (String)appNoFileStoreIdsMap.get(fileStoreId);
            if (null == applicationNumber || applicationNumber.isEmpty()) continue;
            License license = (License)this.persistenceService.find("from License where applicationNumber=?", new Object[]{applicationNumber});
            Assignment wfInitiator = this.assignmentService.getPrimaryAssignmentForUser(license.getCreatedBy().getId());
            DateTime currentDate = new DateTime();
            WorkFlowMatrix wfmatrix = (license = this.licenseUtils.applicationStatusChange(license, "APPROVED")).isReNewApplication() ? this.tradeLicenseWorkflowService.getWfMatrix("TradeLicense", null, null, "RENEWTRADELICENSE", "Digital signed", null) : this.tradeLicenseWorkflowService.getWfMatrix("TradeLicense", null, null, "NEWTRADELICENSE", "Digital signed", null);
            license.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments("Digital signed").withStateValue(wfmatrix.getCurrentState()).withDateInfo(currentDate.toDate()).withOwner(wfInitiator.getPosition()).withNextAction(wfmatrix.getCurrentStatus());
            this.persistenceService.persist((Object)license);
        }
        model.addAttribute("successMessage", (Object)"Digitally Signed Successfully");
        model.addAttribute("fileStoreId", (Object)(fileStoreIdArr.length == 1 ? fileStoreIdArr[0] : ""));
        return "digitalSignature-success";
    }

    @RequestMapping(value={"/tradeLicense/downloadSignedLicenseCertificate"})
    public void downloadSignedLicenseCertificate(HttpServletRequest request, HttpServletResponse response) {
        String signedFileStoreId = request.getParameter("signedFileStoreId");
        File file = this.fileStoreService.fetch(signedFileStoreId, "TL");
        FileStoreMapper fileStoreMapper = this.fileStoreMapperRepository.findByFileStoreId(signedFileStoreId);
        response.setContentType("application/pdf");
        response.setContentType("application/octet-stream");
        response.setHeader("content-disposition", "attachment; filename=\"" + (fileStoreMapper != null ? fileStoreMapper.getFileName() : null) + "\"");
        try (FileInputStream inStream = new FileInputStream(file);
             ServletOutputStream outStream = response.getOutputStream();){
            int bytesRead;
            byte[] buffer = FileUtils.readFileToByteArray((File)file);
            while ((bytesRead = inStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw new ApplicationRuntimeException("Exception while downloading license certificate file", (Throwable)e);
        }
    }
}

