/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.utils.JsonUtils;
import org.egov.tl.entity.dto.BaseRegisterForm;
import org.egov.tl.service.BaseRegisterService;
import org.egov.tl.service.LicenseCategoryService;
import org.egov.tl.service.LicenseStatusService;
import org.egov.tl.web.response.adaptor.BaseRegisterResponseAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"baseregister", "/public/baseregister"})
public class BaseRegisterController {
    private final LicenseStatusService licenseStatusService;
    private final BaseRegisterService baseRegisterService;
    private final LicenseCategoryService licenseCategoryService;
    private final BoundaryService boundaryService;

    @Autowired
    public BaseRegisterController(BoundaryService boundaryService, LicenseCategoryService licenseCategoryService, BaseRegisterService baseRegisterService, LicenseStatusService licenseStatusService) {
        this.boundaryService = boundaryService;
        this.licenseCategoryService = licenseCategoryService;
        this.baseRegisterService = baseRegisterService;
        this.licenseStatusService = licenseStatusService;
    }

    @ModelAttribute
    public BaseRegisterForm baseRegisterForm() {
        return new BaseRegisterForm();
    }

    @RequestMapping(value={"/search-form"}, method={RequestMethod.GET})
    public String searchBaseRegister(Model model) {
        model.addAttribute("categories", (Object)this.licenseCategoryService.getCategoriesOrderByName());
        model.addAttribute("subcategories", Collections.emptyList());
        model.addAttribute("statusList", (Object)this.licenseStatusService.findAll());
        this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("locality", "LOCATION");
        model.addAttribute("wardList", (Object)this.boundaryService.getBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE"));
        return "baseregister-report";
    }

    @RequestMapping(value={"/search-resultList"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    public String search(@ModelAttribute BaseRegisterForm baseRegisterForm) throws IOException {
        return "{ \"data\":" + JsonUtils.toJSON((Collection)this.baseRegisterService.search(baseRegisterForm), BaseRegisterForm.class, BaseRegisterResponseAdaptor.class) + "}";
    }
}

