/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.actions.viewtradelicense;

import java.io.IOException;
import java.util.List;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Actions;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.eis.entity.Assignment;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.web.struts.annotation.ValidationErrorPageExt;
import org.egov.tl.entity.License;
import org.egov.tl.entity.TradeLicense;
import org.egov.tl.entity.WorkflowBean;
import org.egov.tl.service.AbstractLicenseService;
import org.egov.tl.service.TradeLicenseService;
import org.egov.tl.web.actions.BaseLicenseAction;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Results(value={@Result(name={"report"}, location="viewTradeLicense-report.jsp"), @Result(name={"message"}, location="viewTradeLicense-message.jsp"), @Result(name={"closure"}, location="viewTradeLicense-closure.jsp")})
public class ViewTradeLicenseAction
extends BaseLicenseAction<TradeLicense> {
    private static final long serialVersionUID = 1L;
    protected TradeLicense tradeLicense = new TradeLicense();
    private String applicationNo;
    private Long licenseid;
    @Autowired
    private ReportService reportService;
    @Autowired
    private TradeLicenseService tradeLicenseService;

    public TradeLicense getModel() {
        return this.tradeLicense;
    }

    @Action(value="/viewtradelicense/viewTradeLicense-showForApproval")
    public String showForApproval() throws IOException {
        this.tradeLicense = (TradeLicense)this.tradeLicenseService.getLicenseById(this.license().getId());
        return super.showForApproval();
    }

    @Actions(value={@Action(value="/viewtradelicense/viewTradeLicense-view"), @Action(value="/public/viewtradelicense/viewTradeLicense-view")})
    public String view() {
        if (this.license() != null && this.license().getId() != null) {
            this.tradeLicense = (TradeLicense)this.tradeLicenseService.getLicenseById(this.license().getId());
        } else if (this.applicationNo != null && !this.applicationNo.isEmpty()) {
            this.tradeLicense = (TradeLicense)this.tradeLicenseService.getLicenseByApplicationNumber(this.applicationNo);
        }
        return "view";
    }

    @ValidationErrorPage(value="report")
    @Action(value="/viewtradelicense/viewTradeLicense-generateCertificate")
    public String generateCertificate() {
        this.setLicenseIdIfServletRedirect();
        this.tradeLicense = (TradeLicense)this.tradeLicenseService.getLicenseById(this.license().getId());
        this.reportId = this.reportViewerUtil.addReportToTempCache(this.reportService.createReport(this.tradeLicenseService.prepareReportInputData((License)this.license())));
        return "report";
    }

    private void setLicenseIdIfServletRedirect() {
        if (this.tradeLicense.getId() == null && this.getSession().get("model.id") != null) {
            this.tradeLicense.setId(Long.valueOf((Long)this.getSession().get("model.id")));
            this.getSession().remove("model.id");
        }
    }

    protected TradeLicense license() {
        return this.tradeLicense;
    }

    @SkipValidation
    @ValidationErrorPageExt(action="approve", makeCall=true, toMethod="setupWorkflowDetails")
    public String approve() {
        this.setRoleName(this.securityUtils.getCurrentUser().getRoles().toString());
        return super.approve();
    }

    @SkipValidation
    @ValidationErrorPageExt(action="approveRenew", makeCall=true, toMethod="setupWorkflowDetails")
    public String approveRenew() {
        this.setRoleName(this.securityUtils.getCurrentUser().getRoles().toString());
        this.tradeLicense = (TradeLicense)this.tradeLicenseService.getLicenseById(this.license().getId());
        return super.approveRenew();
    }

    protected AbstractLicenseService<TradeLicense> licenseService() {
        return this.tradeLicenseService;
    }

    public WorkflowBean getWorkflowBean() {
        return this.workflowBean;
    }

    public void setWorkflowBean(WorkflowBean workflowBean) {
        this.workflowBean = workflowBean;
    }

    public String getApplicationNo() {
        return this.applicationNo;
    }

    public void setApplicationNo(String applicationNo) {
        this.applicationNo = applicationNo;
    }

    public String getReportId() {
        return this.reportId;
    }

    @Action(value="/viewtradelicense/showclosureform")
    public String showClosureForm() throws IOException {
        if (this.license() != null && this.license().getId() != null) {
            this.tradeLicense = (TradeLicense)this.tradeLicenseService.getLicenseById(this.license().getId());
        }
        if (this.tradeLicense.hasState() && !this.tradeLicense.transitionCompleted()) {
            ServletActionContext.getResponse().setContentType("text/html");
            ServletActionContext.getResponse().getWriter().write("<center style='color:red;font-weight:bolder'>Closure License workflow is in progress !</center>");
            return null;
        }
        return "closure";
    }

    @Action(value="/viewtradelicense/viewTradeLicense-closure")
    public String viewClosure() {
        if (this.license() != null && this.license().getId() != null) {
            this.tradeLicense = (TradeLicense)this.tradeLicenseService.getLicenseById(this.license().getId());
        }
        return "closure";
    }

    @Action(value="/viewtradelicense/viewTradeLicense-cancelLicense")
    public String updateLicenseClosure() {
        this.populateWorkflowBean();
        if (this.getLicenseid() != null) {
            this.tradeLicense = (TradeLicense)this.tradeLicenseService.getLicenseById(this.getLicenseid());
            this.tradeLicenseService.cancelLicenseWorkflow((License)this.tradeLicense, this.workflowBean);
            if (this.hasCSCOperatorRole().booleanValue()) {
                this.addActionMessage(this.getText("license.closure.initiated"));
            } else if (this.workflowBean.getWorkFlowAction().contains("Forward")) {
                List assignments = this.assignmentService.getAssignmentsForPosition(this.workflowBean.getApproverPositionId());
                String nextDesgn = !assignments.isEmpty() ? ((Assignment)assignments.get(0)).getDesignation().getName() : "";
                String userName = !assignments.isEmpty() ? ((Assignment)assignments.get(0)).getEmployee().getName() : "";
                this.addActionMessage(this.getText("license.closure.sent") + " " + nextDesgn + " - " + userName);
            } else if (this.workflowBean.getWorkFlowAction().contains("Reject")) {
                if (this.license().getState().getValue().contains("Rejected")) {
                    List assignments = this.assignmentService.getAssignmentsForPosition(this.license().getState().getInitiatorPosition().getId());
                    String userName = !assignments.isEmpty() ? ((Assignment)assignments.get(0)).getEmployee().getName() : "";
                    this.addActionMessage(this.getText("license.closure.rejectedfirst") + " " + this.license().getState().getInitiatorPosition().getDeptDesig().getDesignation().getName() + " - " + " " + userName);
                } else {
                    this.addActionMessage(this.getText("license.closure.rejected") + " " + this.license().getLicenseNumber());
                }
            } else {
                this.addActionMessage(this.getText("license.closure.msg") + this.license().getLicenseNumber());
            }
        }
        return "message";
    }

    public String getAdditionalRule() {
        return "CLOSURELICENSE";
    }

    public Long getLicenseid() {
        return this.licenseid;
    }

    public void setLicenseid(Long licenseid) {
        this.licenseid = licenseid;
    }

    public Boolean hasCSCOperatorRole() {
        String currentUserRoles = this.securityUtils.getCurrentUser().getRoles().toString();
        return currentUserRoles.contains("CSC Operator");
    }
}

