/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.feematrix;

import java.util.List;
import javax.validation.Valid;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.tl.entity.FeeMatrix;
import org.egov.tl.entity.LicenseAppType;
import org.egov.tl.entity.LicenseCategory;
import org.egov.tl.entity.NatureOfBusiness;
import org.egov.tl.service.FeeMatrixService;
import org.egov.tl.service.LicenseAppTypeService;
import org.egov.tl.service.LicenseCategoryService;
import org.egov.tl.service.NatureOfBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/feematrix/update/{id}"})
public class UpdateFeeMatrixController {
    @Autowired
    private LicenseCategoryService licenseCategoryService;
    @Autowired
    private NatureOfBusinessService natureOfBusinessService;
    @Autowired
    private FinancialYearDAO financialYearDAO;
    @Autowired
    private LicenseAppTypeService licenseAppTypeService;
    @Autowired
    private FeeMatrixService feeMatrixService;

    @ModelAttribute
    public FeeMatrix feeMatrix(@PathVariable Long id) {
        return this.feeMatrixService.getFeeMatrixById(id);
    }

    @ModelAttribute
    public List<LicenseCategory> licenseCategories() {
        return this.licenseCategoryService.getCategoriesOrderByName();
    }

    @ModelAttribute
    public List<NatureOfBusiness> natureOfBusinesses() {
        return this.natureOfBusinessService.getNatureOfBusinesses();
    }

    @ModelAttribute(value="financialYears")
    public List<CFinancialYear> financialYears() {
        return this.financialYearDAO.getAllActiveFinancialYearList();
    }

    @ModelAttribute
    public List<LicenseAppType> licenseAppTypes() {
        return this.licenseAppTypeService.findByDisplayTrue();
    }

    @RequestMapping(method={RequestMethod.GET})
    public String edit() {
        return "feematrix-update";
    }

    @RequestMapping(method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute FeeMatrix feeMatrix, BindingResult bindingResult, RedirectAttributes responseAttribs) {
        if (bindingResult.hasErrors()) {
            return "feematrix-update";
        }
        this.feeMatrixService.update(feeMatrix);
        responseAttribs.addFlashAttribute("message", (Object)"msg.feematrix.update.success");
        return "redirect:/feematrix/view/" + feeMatrix.getId();
    }
}

