/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.demand;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentHibDao;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.utils.JsonUtils;
import org.egov.infra.utils.PdfUtils;
import org.egov.tl.entity.License;
import org.egov.tl.entity.PenaltyRates;
import org.egov.tl.entity.TradeLicense;
import org.egov.tl.entity.dto.DemandNoticeForm;
import org.egov.tl.service.LicenseCategoryService;
import org.egov.tl.service.LicenseStatusService;
import org.egov.tl.service.PenaltyRatesService;
import org.egov.tl.service.TradeLicenseService;
import org.egov.tl.utils.LicenseUtils;
import org.egov.tl.utils.TradeLicenseDemandBillHelper;
import org.egov.tl.web.response.adaptor.DemandNoticeAdaptor;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/demand-notice"})
public class DemandNoticeController {
    private static final String WITH = " with ";
    @Autowired
    private TradeLicenseService tradeLicenseService;
    @Autowired
    private LicenseUtils licenseUtils;
    @Autowired
    private InstallmentHibDao installmentDao;
    @Autowired
    private PenaltyRatesService penaltyRatesService;
    @Autowired
    private CityService cityService;
    @Autowired
    private AppConfigValueService appConfigValueService;
    @Autowired
    private ReportService reportService;
    @Autowired
    private LicenseStatusService licenseStatusService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private LicenseCategoryService licenseCategoryService;

    @GetMapping(value={"search"})
    public String searchFormforNotice(Model model) {
        model.addAttribute("demandnoticesearchForm", (Object)new DemandNoticeForm());
        model.addAttribute("categoryList", (Object)this.licenseCategoryService.getCategories());
        model.addAttribute("subCategoryList", Collections.emptyList());
        List statuslist = this.licenseStatusService.findAll();
        statuslist.remove(this.licenseStatusService.getLicenseStatusByCode("CAN"));
        model.addAttribute("statusList", (Object)statuslist);
        model.addAttribute("localityList", (Object)this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("locality", "LOCATION"));
        model.addAttribute("wardList", (Object)this.boundaryService.getBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE"));
        return "search-demandnotice";
    }

    @PostMapping(value={"search"}, produces={"text/plain"})
    @ResponseBody
    public String searchResult(@ModelAttribute DemandNoticeForm demandnoticeForm) throws IOException {
        return "{ \"data\":" + JsonUtils.toJSON((Collection)this.tradeLicenseService.getLicenseDemandNotices(demandnoticeForm), DemandNoticeForm.class, DemandNoticeAdaptor.class) + "}";
    }

    @GetMapping(value={"generate/{licenseId}"})
    @ResponseBody
    public ResponseEntity<byte[]> generateDemandNotice(@PathVariable Long licenseId) {
        TradeLicense license = (TradeLicense)this.tradeLicenseService.getLicenseById(licenseId);
        return this.generateReport(license);
    }

    @GetMapping(value={"generate"})
    @ResponseBody
    public String mergeAndDownload(@ModelAttribute DemandNoticeForm searchRequest, HttpServletResponse response) throws IOException {
        List demandNotices = this.tradeLicenseService.getLicenseDemandNotices(searchRequest);
        ArrayList<ByteArrayInputStream> demandNoticePDFStreams = new ArrayList<ByteArrayInputStream>();
        if (!demandNotices.isEmpty()) {
            for (DemandNoticeForm tlNotice : demandNotices) {
                if (tlNotice == null) continue;
                ResponseEntity demandNotice = this.generateReport((TradeLicense)this.tradeLicenseService.getLicenseById(tlNotice.getLicenseId()));
                byte[] bFile = (byte[])demandNotice.getBody();
                demandNoticePDFStreams.add(new ByteArrayInputStream(bFile));
            }
            if (!demandNoticePDFStreams.isEmpty()) {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                byte[] data = PdfUtils.appendFiles(demandNoticePDFStreams, (OutputStream)output);
                response.setHeader("content-disposition", "inline;filename=License Demand Notice.pdf");
                response.setContentType("application/pdf");
                response.setContentLength(data.length);
                response.getOutputStream().write(data);
            }
        }
        return "";
    }

    private ResponseEntity<byte[]> generateReport(TradeLicense license) {
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        if (license != null && license.getCurrentDemand() != null) {
            Installment currentInstallment = license.getCurrentDemand().getEgInstallmentMaster();
            reportParams.put("cityName", ApplicationThreadLocals.getMunicipalityName());
            reportParams.put("licenseNumber", license.getLicenseNumber());
            reportParams.put("ownerName", license.getLicensee().getApplicantName());
            reportParams.put("tradeNature", license.getTradeName().getName());
            reportParams.put("tradeName", license.getNameOfEstablishment());
            reportParams.put("tradeAddress", license.getAddress());
            reportParams.put("cityUrl", ApplicationThreadLocals.getDomainURL());
            this.getActDeclarationDetailBasedOnCityGrade(reportParams);
            reportParams.put("installmentYear", DateUtils.toYearFormat((Date)currentInstallment.getFromDate()) + "-" + DateUtils.toYearFormat((Date)currentInstallment.getToDate()));
            reportParams.put("currentDate", DateUtils.currentDateToDefaultDateFormat());
            List previousInstallment = this.installmentDao.fetchPreviousInstallmentsInDescendingOrderByModuleAndDate(this.licenseUtils.getModule("Trade License"), currentInstallment.getToDate(), 1);
            if (!previousInstallment.isEmpty()) {
                BigDecimal arrLicensePenalty;
                BigDecimal arrLicenseFee;
                BigDecimal currLicenseFee;
                reportParams.put("lastyear", DateUtils.toYearFormat((Date)((Installment)previousInstallment.get(0)).getFromDate()) + "-" + DateTimeFormat.forPattern((String)"yy").print((ReadablePartial)new LocalDate((Object)((Installment)previousInstallment.get(0)).getToDate())));
                Date endDateOfPreviousFinancialYear = new DateTime((Object)((Installment)previousInstallment.get(0)).getFromDate()).withMonthOfYear(12).withDayOfMonth(31).toDate();
                reportParams.put("endDateOfPreviousFinancialYear", DateUtils.getDefaultFormattedDate((Date)endDateOfPreviousFinancialYear));
                Map outstandingFees = this.tradeLicenseService.getOutstandingFeeForDemandNotice(license, currentInstallment, (Installment)previousInstallment.get(0));
                Map licenseFees = (Map)outstandingFees.get("License Fee");
                if (licenseFees != null) {
                    currLicenseFee = licenseFees.get("current") == null ? BigDecimal.ZERO : ((BigDecimal)licenseFees.get("current")).setScale(0, 4);
                    arrLicenseFee = licenseFees.get("arrear") == null ? BigDecimal.ZERO : ((BigDecimal)licenseFees.get("arrear")).setScale(0, 4);
                    arrLicensePenalty = licenseFees.get("penalty") == null ? BigDecimal.ZERO : ((BigDecimal)licenseFees.get("penalty")).setScale(0, 4);
                } else {
                    currLicenseFee = BigDecimal.ZERO;
                    arrLicenseFee = BigDecimal.ZERO;
                    arrLicensePenalty = BigDecimal.ZERO;
                }
                BigDecimal totalAmount = currLicenseFee.add(arrLicenseFee).add(arrLicensePenalty);
                LinkedList monthWiseDemandDetails = new LinkedList();
                this.getMonthWiseLatePenaltyFeeDetails(license, currentInstallment, currLicenseFee, arrLicenseFee, arrLicensePenalty, monthWiseDemandDetails);
                reportParams.put("monthWiseDemandDetails", monthWiseDemandDetails);
                reportParams.put("licenseFee", currLicenseFee);
                reportParams.put("penaltyFee", arrLicensePenalty);
                reportParams.put("arrearLicenseFee", arrLicenseFee);
                reportParams.put("totalLicenseFee", totalAmount.setScale(0, 4));
                List penaltyRates = this.penaltyRatesService.search(license.getLicenseAppType().getId());
                reportParams.put("penaltyCalculationMessage", this.getPenaltyRateDetails(penaltyRates, currentInstallment));
                reportParams.put("currentYear", DateUtils.toYearFormat((Date)currentInstallment.getFromDate()));
            }
        }
        ReportRequest reportInput = new ReportRequest("tl_demand_notice", (Object)license, reportParams);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=License Demand Notice.pdf");
        ReportOutput reportOutput = this.reportService.createReport(reportInput);
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }

    private void getActDeclarationDetailBasedOnCityGrade(Map<String, Object> reportParams) {
        String cityGrade = (String)this.cityService.cityDataForKey("cityGrade");
        if ("Corp".equalsIgnoreCase(cityGrade)) {
            List corporationAct = this.appConfigValueService.getConfigValuesByModuleAndKey("Trade License", "Trade license Act corporation");
            reportParams.put("actDeclaration", corporationAct != null && corporationAct.get(0) != null ? ((AppConfigValues)corporationAct.get(0)).getValue() : " ");
        } else {
            List municipalityAct = this.appConfigValueService.getConfigValuesByModuleAndKey("Trade License", "Trade license Act Muncipalities");
            reportParams.put("actDeclaration", municipalityAct != null && municipalityAct.get(0) != null ? ((AppConfigValues)municipalityAct.get(0)).getValue() : " ");
        }
    }

    private void getMonthWiseLatePenaltyFeeDetails(TradeLicense license, Installment currentInstallment, BigDecimal currLicenseFee, BigDecimal arrLicenseFee, BigDecimal arrLicensePenalty, List<TradeLicenseDemandBillHelper> monthWiseDemandDetails) {
        Date previousInstallmentEndDate = new DateTime((Object)currentInstallment.getFromDate()).withMonthOfYear(3).withDayOfMonth(31).toDate();
        String installmentYear = DateUtils.toYearFormat((Date)currentInstallment.getFromDate());
        Map monthMap = DateUtils.getAllMonths();
        for (int i = 1; i <= 12; ++i) {
            TradeLicenseDemandBillHelper demandBillDtl = new TradeLicenseDemandBillHelper();
            DateTime financialYearDate = new DateTime((Object)currentInstallment.getFromDate()).withMonthOfYear(i);
            Date monthEndDate = new DateTime((Object)financialYearDate).withDayOfMonth(financialYearDate.dayOfMonth().getMaximumValue()).toDate();
            BigDecimal penaltyAmt = this.penaltyRatesService.calculatePenalty((License)license, previousInstallmentEndDate, monthEndDate, currLicenseFee);
            demandBillDtl.setMonth(((String)monthMap.get(i)).concat(", ").concat(installmentYear));
            demandBillDtl.setArrersWithPenalty(arrLicenseFee.add(arrLicensePenalty));
            demandBillDtl.setLicenseFee(currLicenseFee);
            demandBillDtl.setPenalty(penaltyAmt.setScale(0, 4));
            demandBillDtl.setTotalDues(arrLicenseFee.add(arrLicensePenalty).add(currLicenseFee).add(penaltyAmt).setScale(0, 4));
            monthWiseDemandDetails.add(demandBillDtl);
        }
    }

    public String getPenaltyRateDetails(List<PenaltyRates> penaltyRates, Installment currentInstallment) {
        StringBuilder penaltylist = new StringBuilder();
        for (PenaltyRates penaltyRate : penaltyRates) {
            LocalDate currentinstStartdate = LocalDate.fromDateFields((Date)currentInstallment.getFromDate());
            if (penaltyRate.getRate() <= 0.0) {
                penaltylist.append("Before ").append(DateUtils.getDefaultFormattedDate((Date)currentinstStartdate.plusDays(penaltyRate.getToRange().intValue()).toDate())).append(" without penalty\n");
            }
            if (!(penaltyRate.getRate() > 0.0)) continue;
            if (penaltyRate.getToRange() >= 999L) {
                penaltylist.append("    After ").append(DateUtils.getDefaultFormattedDate((Date)currentinstStartdate.plusDays(penaltyRate.getFromRange().intValue()).toDate())).append(WITH).append(penaltyRate.getRate().intValue()).append("% penalty");
                continue;
            }
            if (penaltyRate.getFromRange() <= -999L) {
                penaltylist.append("Before ").append(DateUtils.getDefaultFormattedDate((Date)currentinstStartdate.plusDays(penaltyRate.getToRange().intValue()).toDate())).append(WITH).append(penaltyRate.getRate().intValue()).append("% penalty\n");
                continue;
            }
            penaltylist.append("    From ").append(DateUtils.getDefaultFormattedDate((Date)currentinstStartdate.plusDays(penaltyRate.getFromRange().intValue()).toDate())).append(" to ").append(DateUtils.getDefaultFormattedDate((Date)currentinstStartdate.plusDays(penaltyRate.getToRange().intValue()).toDate())).append(WITH).append(penaltyRate.getRate().intValue()).append("% penalty\n");
        }
        return penaltylist.toString();
    }
}

