/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.actions.integration;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.tl.entity.License;
import org.egov.tl.service.TradeLicenseService;
import org.egov.tl.service.integration.LicenseBillService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name={"showfees"}, location="license-showfees.jsp"), @Result(name={"success"}, location="licenseBillCollect.jsp")})
public class LicenseBillCollectAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    private Long licenseId;
    private String collectXML;
    @Autowired
    private transient LicenseBillService licenseBillService;
    @Autowired
    @Qualifier(value="tradeLicenseService")
    private transient TradeLicenseService tradeLicenseService;
    private Map<String, Map<String, BigDecimal>> outstandingFee;

    public String execute() throws IOException {
        License license = this.tradeLicenseService.getLicenseById(this.licenseId);
        this.setOutstandingFee(this.licenseBillService.getPaymentFee(license));
        this.setLicenseId(this.licenseId);
        return "showfees";
    }

    @Action(value="/integration/licenseBillCollect-collectfees")
    public String payFee() throws IOException {
        License license = this.tradeLicenseService.getLicenseById(this.licenseId);
        if (license.isPaid()) {
            ServletActionContext.getResponse().setContentType("text/html");
            ServletActionContext.getResponse().getWriter().write("<center style='color:red;font-weight:bolder'>License Fee already collected !</center>");
            return null;
        }
        this.collectXML = URLEncoder.encode(this.licenseBillService.createLicenseBillXML(license), "UTF-8");
        return "success";
    }

    public Object getModel() {
        return null;
    }

    public String getCollectXML() {
        return this.collectXML;
    }

    public Long getLicenseId() {
        return this.licenseId;
    }

    public void setLicenseId(Long licenseId) {
        this.licenseId = licenseId;
    }

    public Map<String, Map<String, BigDecimal>> getOutstandingFee() {
        return this.outstandingFee;
    }

    public void setOutstandingFee(Map<String, Map<String, BigDecimal>> outstandingFee) {
        this.outstandingFee = outstandingFee;
    }
}

