/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.subcategory;

import java.util.List;
import org.egov.tl.entity.LicenseSubCategory;
import org.egov.tl.entity.LicenseSubCategoryDetails;
import org.egov.tl.service.LicenseSubCategoryService;
import org.egov.tl.service.SubCategoryDetailsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/licensesubcategory"})
public class ViewSubCategoryController {
    @Autowired
    private LicenseSubCategoryService licenseSubCategoryService;
    @Autowired
    private SubCategoryDetailsService subCategoryDetailsService;

    @RequestMapping(value={"by-category"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<LicenseSubCategory> subcategories(@RequestParam Long categoryId) {
        return this.licenseSubCategoryService.getSubCategoriesByCategory(categoryId);
    }

    @RequestMapping(value={"detail"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<LicenseSubCategoryDetails> subcategoryDetailsBySubcategoryId(@RequestParam Long subCategoryId) {
        return this.subCategoryDetailsService.getSubcategoryDetailsBySubcategoryId(subCategoryId);
    }

    @RequestMapping(value={"detail-by-feetype"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public LicenseSubCategoryDetails subcategoryDetailBySubcategoryAndFeeType(@RequestParam Long subCategoryId, @RequestParam Long feeTypeId) {
        return this.subCategoryDetailsService.getSubcategoryDetailBySubcategoryAndFeeType(subCategoryId, feeTypeId);
    }

    @ModelAttribute
    public LicenseSubCategory licenseSubCategory(@PathVariable(required=false) String code) {
        return this.licenseSubCategoryService.getSubCategoryByCode(code);
    }

    @RequestMapping(value={"view/{code}"}, method={RequestMethod.GET})
    public String viewSubCategory() {
        return "subcategory-view";
    }
}

