/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller;

import java.util.List;
import org.egov.commons.CFinancialYear;
import org.egov.commons.service.CFinancialYearService;
import org.egov.tl.entity.DemandGenerationLog;
import org.egov.tl.entity.DemandGenerationLogDetail;
import org.egov.tl.entity.License;
import org.egov.tl.entity.TradeLicense;
import org.egov.tl.entity.enums.ProcessStatus;
import org.egov.tl.service.DemandGenerationService;
import org.egov.tl.service.TradeLicenseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/demand"})
public class DemandGenerationController {
    @Autowired
    private DemandGenerationService demandGenerationService;
    @Autowired
    private CFinancialYearService financialYearService;
    @Autowired
    private TradeLicenseService tradeLicenseService;

    @ModelAttribute(value="financialYearList")
    public List<CFinancialYear> financialYearList() {
        return this.financialYearService.getAllFinancialYears();
    }

    @RequestMapping(value={"generate"}, method={RequestMethod.GET})
    public String newForm() {
        return "demand-generate";
    }

    @RequestMapping(value={"generate"}, method={RequestMethod.POST})
    public String generateDemand(@RequestParam String installmentYear, RedirectAttributes responseAttribs) {
        DemandGenerationLog bulkDemandGenerationLog = this.demandGenerationService.generateDemand(installmentYear);
        responseAttribs.addFlashAttribute("demandGenerationLog", (Object)bulkDemandGenerationLog);
        responseAttribs.addFlashAttribute("message", (Object)("msg.demand.generation." + bulkDemandGenerationLog.getDemandGenerationStatus()));
        return "redirect:/demand/generate";
    }

    @RequestMapping(value={"regenerate"}, method={RequestMethod.POST})
    public String regenerateDemand(@RequestParam String installmentYear, RedirectAttributes responseAttribs) {
        DemandGenerationLog bulkDemandGenerationLog = this.demandGenerationService.retryFailedDemandGeneration(installmentYear);
        responseAttribs.addFlashAttribute("demandGenerationLog", (Object)bulkDemandGenerationLog);
        responseAttribs.addFlashAttribute("message", (Object)("msg.demand.generation." + bulkDemandGenerationLog.getDemandGenerationStatus()));
        return "redirect:/demand/generate";
    }

    @RequestMapping(value={"licensedemandgenerate"}, method={RequestMethod.GET})
    public String generateDemandForLicense(@RequestParam Long licenseId, Model model) {
        model.addAttribute("licenseNumber", (Object)((TradeLicense)this.tradeLicenseService.getLicenseById(licenseId)).getLicenseNumber());
        model.addAttribute("financialYear", (Object)this.demandGenerationService.getLatestFinancialYear().getFinYearRange());
        return "demandgenerate-result";
    }

    @RequestMapping(value={"licensedemandgenerate"}, method={RequestMethod.POST})
    public String generateDemandForLicense(@RequestParam String licenseNumber, RedirectAttributes redirectAttrs) {
        License license = this.tradeLicenseService.getLicenseByLicenseNumber(licenseNumber);
        DemandGenerationLogDetail demandGenerationLogDetail = this.demandGenerationService.generateLicenseDemand(license);
        redirectAttrs.addFlashAttribute("message", (Object)(ProcessStatus.COMPLETED.equals((Object)demandGenerationLogDetail.getStatus()) ? "msg.demand.generation.completed" : "msg.demand.generation.incomplete"));
        redirectAttrs.addAttribute("licenseId", (Object)license.getId());
        return "redirect:/demand/licensedemandgenerate";
    }
}

