/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.report;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.web.support.ui.DataTable;
import org.egov.infra.web.utils.WebUtils;
import org.egov.tl.entity.dto.BaseRegisterRequest;
import org.egov.tl.entity.view.BaseRegister;
import org.egov.tl.service.BaseRegisterService;
import org.egov.tl.service.LicenseCategoryService;
import org.egov.tl.service.LicenseStatusService;
import org.egov.tl.web.response.adaptor.BaseRegisterResponseAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report/base-register"})
public class BaseRegisterController {
    @Autowired
    private LicenseStatusService licenseStatusService;
    @Autowired
    private BaseRegisterService baseRegisterService;
    @Autowired
    private LicenseCategoryService licenseCategoryService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private ReportService reportService;

    @GetMapping(value={"search"})
    public String baseRegisterSearchForm(Model model) {
        model.addAttribute("baseRegister", (Object)new BaseRegister());
        model.addAttribute("categories", (Object)this.licenseCategoryService.getCategoriesOrderByName());
        model.addAttribute("subcategories", Collections.emptyList());
        model.addAttribute("statusList", (Object)this.licenseStatusService.findAll());
        model.addAttribute("filters", Arrays.asList("All", "Defaulters"));
        this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("locality", "LOCATION");
        model.addAttribute("wardList", (Object)this.boundaryService.getBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE"));
        return "baseregister-report";
    }

    @PostMapping(value={"search"}, produces={"text/plain"})
    @ResponseBody
    public String searchBaseRegister(BaseRegisterRequest baseRegisterRequest) {
        return new DataTable(this.baseRegisterService.pagedBaseRegisterRecords(baseRegisterRequest), (long)baseRegisterRequest.draw()).toJson(BaseRegisterResponseAdaptor.class);
    }

    @GetMapping(value={"grand-total"})
    @ResponseBody
    public Object[] baseRegisterGrandTotal(BaseRegisterRequest baseRegisterRequest) {
        return this.baseRegisterService.baseRegisterGrandTotal(baseRegisterRequest);
    }

    @GetMapping(value={"download"})
    @ResponseBody
    public ResponseEntity<InputStreamResource> downloadReport(BaseRegisterRequest baseRegisterRequest) {
        ReportRequest reportRequest = new ReportRequest("tl_baseregister_report", (Collection)this.baseRegisterService.getAllBaseRegisterRecords(baseRegisterRequest), new HashMap());
        reportRequest.setReportFormat(baseRegisterRequest.getPrintFormat());
        reportRequest.setReportName("base_register_report");
        return WebUtils.reportToResponseEntity((ReportRequest)reportRequest, (ReportOutput)this.reportService.createReport(reportRequest));
    }
}

