/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.payment;

import java.io.IOException;
import java.util.Collection;
import org.egov.infra.utils.JsonUtils;
import org.egov.tl.entity.License;
import org.egov.tl.entity.dto.DCBReportSearchRequest;
import org.egov.tl.entity.view.DCBReportResult;
import org.egov.tl.service.DCBReportService;
import org.egov.tl.service.TradeLicenseService;
import org.egov.tl.web.response.adaptor.OnlineDCBReportResponseAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/dcb/view"})
public class ViewDCBController {
    @Autowired
    private TradeLicenseService tradeLicenseService;
    @Autowired
    private DCBReportService dCBReportService;

    @GetMapping(value={"{id}"})
    public String search(@PathVariable Long id, Model model, DCBReportSearchRequest searchRequest) throws IOException {
        License licenseObj = this.tradeLicenseService.getLicenseById(id);
        searchRequest.setLicensenumber(licenseObj.getLicenseNumber());
        model.addAttribute("license", (Object)licenseObj);
        model.addAttribute("dcbreport", (Object)JsonUtils.toJSON((Collection)this.dCBReportService.getAllDCBRecords(searchRequest), DCBReportResult.class, OnlineDCBReportResponseAdaptor.class));
        return "view-license-dcb";
    }
}

