/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.demand;

import java.util.Collection;
import java.util.List;
import org.egov.commons.CFinancialYear;
import org.egov.commons.service.CFinancialYearService;
import org.egov.infra.utils.JsonUtils;
import org.egov.tl.entity.DemandGenerationLog;
import org.egov.tl.entity.DemandGenerationLogDetail;
import org.egov.tl.entity.License;
import org.egov.tl.entity.TradeLicense;
import org.egov.tl.entity.enums.ProcessStatus;
import org.egov.tl.service.DemandGenerationService;
import org.egov.tl.service.TradeLicenseService;
import org.egov.tl.web.response.adaptor.DemandGenerationResponseAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/demand"})
public class DemandGenerationController {
    private static final String DEMAND_GENERATION_STATUS_MSG = "msg.demand.generation.%s";
    private static final String GENERATE_DEMAND_RESPONSE_URL = "redirect:/demand/generate";
    @Autowired
    private DemandGenerationService demandGenerationService;
    @Autowired
    private CFinancialYearService financialYearService;
    @Autowired
    private TradeLicenseService tradeLicenseService;

    @ModelAttribute(value="financialYearList")
    public List<CFinancialYear> financialYearList() {
        return this.financialYearService.getAllFinancialYears();
    }

    @RequestMapping(value={"generate"}, method={RequestMethod.GET})
    public String newForm() {
        return "demand-generate";
    }

    @RequestMapping(value={"generate"}, method={RequestMethod.POST})
    public String generateDemand(@RequestParam String installmentYear, RedirectAttributes responseAttribs) {
        DemandGenerationLog bulkDemandGenerationLog = this.demandGenerationService.generateDemand(installmentYear);
        this.prepareReponseData(bulkDemandGenerationLog, responseAttribs);
        return GENERATE_DEMAND_RESPONSE_URL;
    }

    @RequestMapping(value={"regenerate"}, method={RequestMethod.POST})
    public String regenerateDemand(@RequestParam String installmentYear, RedirectAttributes responseAttribs) {
        DemandGenerationLog bulkDemandGenerationLog = this.demandGenerationService.retryFailedDemandGeneration(installmentYear);
        this.prepareReponseData(bulkDemandGenerationLog, responseAttribs);
        return GENERATE_DEMAND_RESPONSE_URL;
    }

    @RequestMapping(value={"generatemissing"}, method={RequestMethod.POST})
    public String generateMissingDemand(@RequestParam String installmentYear, RedirectAttributes responseAttribs) {
        DemandGenerationLog bulkDemandGenerationLog = this.demandGenerationService.generateMissingDemand(installmentYear);
        this.prepareReponseData(bulkDemandGenerationLog, responseAttribs);
        return GENERATE_DEMAND_RESPONSE_URL;
    }

    @RequestMapping(value={"licensedemandgenerate"}, method={RequestMethod.GET})
    public String generateDemandForLicense(@RequestParam Long licenseId, Model model) {
        model.addAttribute("licenseNumber", (Object)((TradeLicense)this.tradeLicenseService.getLicenseById(licenseId)).getLicenseNumber());
        model.addAttribute("financialYear", (Object)this.demandGenerationService.getLatestFinancialYear().getFinYearRange());
        return "demandgenerate-result";
    }

    @RequestMapping(value={"licensedemandgenerate"}, method={RequestMethod.POST})
    public String generateDemandForLicense(@RequestParam String licenseNumber, RedirectAttributes redirectAttrs) {
        License license = this.tradeLicenseService.getLicenseByLicenseNumber(licenseNumber);
        boolean generationStatus = this.demandGenerationService.generateLicenseDemand(license);
        redirectAttrs.addFlashAttribute("message", (Object)(generationStatus ? "msg.demand.generation.completed" : "msg.demand.generation.incomplete"));
        redirectAttrs.addAttribute("licenseId", (Object)license.getId());
        return "redirect:/demand/licensedemandgenerate";
    }

    private void prepareReponseData(DemandGenerationLog demandGenerationLog, RedirectAttributes responseAttribs) {
        responseAttribs.addFlashAttribute("installmentYear", (Object)demandGenerationLog.getInstallmentYear());
        responseAttribs.addFlashAttribute("retry", (Object)demandGenerationLog.getDemandGenerationStatus().equals((Object)ProcessStatus.INCOMPLETE));
        responseAttribs.addFlashAttribute("demandgenerationdata", (Object)JsonUtils.toJSON((Collection)demandGenerationLog.getDetails(), DemandGenerationLogDetail.class, DemandGenerationResponseAdaptor.class));
        responseAttribs.addFlashAttribute("message", (Object)String.format(DEMAND_GENERATION_STATUS_MSG, demandGenerationLog.getDemandGenerationStatus()));
    }
}

