/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.category;

import javax.validation.Valid;
import org.egov.tl.entity.LicenseCategory;
import org.egov.tl.service.LicenseCategoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/licensecategory"})
public class UpdateCategoryController {
    @Autowired
    private LicenseCategoryService licenseCategoryService;

    @ModelAttribute
    public LicenseCategory licenseCategory(@PathVariable String code) {
        return this.licenseCategoryService.getCategoryByCode(code);
    }

    @RequestMapping(value={"/update/{code}"}, method={RequestMethod.GET})
    public String showUpdateCategoryForm() {
        return "licensecategory-update";
    }

    @RequestMapping(value={"/update/{code}"}, method={RequestMethod.POST})
    public String updateCategory(@ModelAttribute @Valid LicenseCategory licenseCategory, BindingResult bindingResult, RedirectAttributes responseAttrbs) {
        if (bindingResult.hasErrors()) {
            return "licensecategory-update";
        }
        this.licenseCategoryService.saveCategory(licenseCategory);
        responseAttrbs.addFlashAttribute("message", (Object)"msg.success.category.update");
        return "redirect:/licensecategory/view/" + licenseCategory.getCode();
    }
}

