/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.actions.search;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.opensymphony.xwork2.validator.annotations.Validations;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.tl.entity.License;
import org.egov.tl.service.TradeLicenseService;
import org.egov.tl.service.masters.LicenseCategoryService;
import org.egov.tl.web.actions.search.SearchForm;
import org.egov.tl.web.actions.search.SearchTradeResultHelperAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Validations
@Results(value={@Result(name="new", location="searchTrade-new.jsp")})
public class SearchTradeAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    private final SearchForm searchForm = new SearchForm();
    private String roleName;
    private String applicationNumber;
    private String licenseNumber;
    private String oldLicenseNumber;
    private Long categoryId;
    private Long subCategoryId;
    private String tradeTitle;
    private String tradeOwnerName;
    private String propertyAssessmentNo;
    private String mobileNo;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    @Qualifier(value="licenseCategoryService")
    protected LicenseCategoryService licenseCategoryService;
    @Autowired
    private TradeLicenseService tradeLicenseService;

    public Object getModel() {
        return this.searchForm;
    }

    public void prepare() {
        super.prepare();
        this.addDropdownData("categoryList", this.licenseCategoryService.findAll());
        this.addDropdownData("subCategoryList", Collections.emptyList());
        this.setRoleName(this.securityUtils.getCurrentUser().getRoles().toString());
    }

    @Action(value="/search/searchTrade-newForm")
    public String newForm() {
        return "new";
    }

    @Action(value="/search/searchTrade-search")
    public void search() throws IOException {
        List resultList = new ArrayList();
        String result = null;
        List licenses = this.tradeLicenseService.searchTradeLicense(this.applicationNumber, this.licenseNumber, this.oldLicenseNumber, this.categoryId, this.subCategoryId, this.tradeTitle, this.tradeOwnerName, this.propertyAssessmentNo, this.mobileNo);
        resultList = this.prepareOutput(licenses);
        result = "{ \"data\":" + this.toJSON(resultList) + "}";
        HttpServletResponse response = ServletActionContext.getResponse();
        response.setContentType("application/json");
        IOUtils.write((String)result, (Writer)response.getWriter());
    }

    private Object toJSON(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(SearchForm.class, (Object)new SearchTradeResultHelperAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }

    private List<SearchForm> prepareOutput(List<? extends License> licenseList) {
        LinkedList<SearchForm> finalList = new LinkedList<SearchForm>();
        for (License license : licenseList) {
            SearchForm searchFormInfo = new SearchForm();
            searchFormInfo.setLicenseId(license.getId());
            searchFormInfo.setApplicationNumber(license.getApplicationNumber());
            searchFormInfo.setLicenseNumber(license.getLicenseNumber());
            searchFormInfo.setOldLicenseNumber(license.getOldLicenseNumber());
            searchFormInfo.setCategoryName(license.getCategory().getName());
            searchFormInfo.setSubCategoryName(license.getTradeName().getName());
            searchFormInfo.setTradeTitle(license.getNameOfEstablishment());
            searchFormInfo.setTradeOwnerName(license.getLicensee().getApplicantName());
            searchFormInfo.setMobileNo(license.getLicensee().getMobilePhoneNumber());
            searchFormInfo.setPropertyAssessmentNo(license.getAssessmentNo() != null ? license.getAssessmentNo() : "");
            ArrayList<String> licenseActions = new ArrayList<String>();
            licenseActions.add("View Trade");
            if (license.getEgwStatus() != null) {
                if (this.roleName.contains("Collection Operator") && !license.isPaid() && !license.isStateRejected() && license.getEgwStatus().getCode().equalsIgnoreCase("COLLECTIONPENDING")) {
                    licenseActions.add("Collect Fees");
                } else if (license.getStatus() != null && license.getStatus().getStatusCode().equalsIgnoreCase("ACT") && !this.roleName.contains("Collection Operator")) {
                    licenseActions.add("Print Certificate");
                }
            } else if (license.isLegacy() && !license.isPaid()) {
                licenseActions.add("Modify Legacy License");
            }
            if ((this.roleName.contains("TLCreator") || this.roleName.contains("TLApprover")) && !license.isPaid() && !license.getLicenseAppType().getName().equals("Renew") && license.getStatus() != null && license.getStatus().getStatusCode().equalsIgnoreCase("ACT")) {
                licenseActions.add("Renew License");
            }
            if (this.roleName.contains("TLApprover") && license.getDateOfExpiry() != null && this.checkForRenewalNotice(license.getDateOfExpiry())) {
                licenseActions.add("Renewal Notice");
            }
            searchFormInfo.setActions(licenseActions);
            finalList.add(searchFormInfo);
        }
        return finalList;
    }

    public boolean acceptableParameterName(String paramName) {
        List<String> nonAcceptable = Arrays.asList("struts.token.name", "struts.token", "token.name");
        boolean retValue = super.acceptableParameterName(paramName);
        return retValue ? !nonAcceptable.contains(paramName) : retValue;
    }

    public boolean checkForRenewalNotice(Date dateOfExpiry) {
        boolean readyForRenewal = false;
        Calendar currentDate = Calendar.getInstance();
        Calendar renewalDate = Calendar.getInstance();
        renewalDate.setTime(dateOfExpiry);
        renewalDate.add(5, -90);
        if (renewalDate.before(currentDate) || renewalDate.equals(currentDate)) {
            readyForRenewal = true;
        }
        return readyForRenewal;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getApplicationNumber() {
        return this.applicationNumber;
    }

    public void setApplicationNumber(String applicationNumber) {
        this.applicationNumber = applicationNumber;
    }

    public String getLicenseNumber() {
        return this.licenseNumber;
    }

    public void setLicenseNumber(String licenseNumber) {
        this.licenseNumber = licenseNumber;
    }

    public String getOldLicenseNumber() {
        return this.oldLicenseNumber;
    }

    public void setOldLicenseNumber(String oldLicenseNumber) {
        this.oldLicenseNumber = oldLicenseNumber;
    }

    public Long getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public Long getSubCategoryId() {
        return this.subCategoryId;
    }

    public void setSubCategoryId(Long subCategoryId) {
        this.subCategoryId = subCategoryId;
    }

    public String getTradeTitle() {
        return this.tradeTitle;
    }

    public void setTradeTitle(String tradeTitle) {
        this.tradeTitle = tradeTitle;
    }

    public String getTradeOwnerName() {
        return this.tradeOwnerName;
    }

    public void setTradeOwnerName(String tradeOwnerName) {
        this.tradeOwnerName = tradeOwnerName;
    }

    public String getPropertyAssessmentNo() {
        return this.propertyAssessmentNo;
    }

    public void setPropertyAssessmentNo(String propertyAssessmentNo) {
        this.propertyAssessmentNo = propertyAssessmentNo;
    }

    public String getMobileNo() {
        return this.mobileNo;
    }

    public void setMobileNo(String mobileNo) {
        this.mobileNo = mobileNo;
    }
}

