/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.actions.domain;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.pims.commons.Designation;
import org.egov.tl.entity.FeeMatrixDetail;
import org.egov.tl.entity.FeeType;
import org.egov.tl.entity.LicenseSubCategory;
import org.egov.tl.entity.LicenseSubCategoryDetails;
import org.egov.tl.entity.PenaltyRates;
import org.egov.tl.service.FeeMatrixDetailService;
import org.egov.tl.service.PenaltyRatesService;
import org.egov.tl.service.masters.LicenseSubCategoryService;
import org.egov.tl.utils.LicenseUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Results(value={@Result(name="ward", location="commonAjax-ward.jsp"), @Result(name="subcategory", location="commonAjax-subcategory.jsp"), @Result(name="feeType", location="commonAjax-feeType.jsp"), @Result(name="unitOfMeasurement", location="commonAjax-unitOfMeasurement.jsp"), @Result(name="designation", location="commonAjax-designation.jsp"), @Result(name="users", location="commonAjax-users.jsp"), @Result(name="deleteRow", location="commonAjax-deleteRow.jsp"), @Result(name="SUCCESS", type="redirectAction", location="CommonAjaxAction.action"), @Result(name="AJAX_RESULT", type="stream", location="returnStream", params={"contentType", "text/plain"})})
public class CommonAjaxAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(CommonAjaxAction.class);
    public static final String LOCATIONS = "locations";
    public static final String STREETS = "streets";
    public static final String DIVISIONS = "divisions";
    public static final String AREAS = "areas";
    private static final String AREA = "area";
    private static final String LOCATION = "location";
    private int divisionId;
    private int areaId;
    private int locationId;
    private int zoneId;
    private Long categoryId;
    private Long subCategoryId;
    private Long feeTypeId;
    private Long feeMatrixDetailId;
    private Long penaltyRateId;
    private List<Boundary> locationList = new LinkedList();
    private List<Boundary> areaList = new LinkedList();
    private List<Boundary> streetList = new LinkedList();
    private List<Boundary> divisionList = new LinkedList();
    private String returnStream = "";
    private List<Designation> designationList;
    private Integer departmentId;
    private Integer designationId;
    private List<User> allActiveUsersByGivenDesg;
    protected LicenseUtils licenseUtils;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private EisCommonService eisCommonService;
    @Autowired
    private FeeMatrixDetailService feeMatrixDetailService;
    @Autowired
    private PenaltyRatesService penaltyRatesService;
    private String rateType;
    private Long uomId;
    private String uomName;
    @Autowired
    private LicenseSubCategoryService licenseSubCategoryService;
    private List<LicenseSubCategory> subCategoryList;
    private List<FeeType> feeTypeList = new ArrayList();

    public InputStream getReturnStream() {
        ByteArrayInputStream is = new ByteArrayInputStream(this.returnStream.getBytes());
        return is;
    }

    public Object getModel() {
        return null;
    }

    public String populateLocations() {
        try {
            this.locationList = this.boundaryService.getChildBoundariesByBoundaryId(Long.valueOf(this.areaId));
            StringBuilder result = new StringBuilder();
            for (Boundary boundary : this.locationList) {
                result.append("Text:").append(boundary.getName()).append("Value:").append(boundary.getId()).append("\n");
            }
            this.returnStream = result.toString();
        }
        catch (Exception e) {
            LOGGER.error((Object)("populateLocations() - Error while loading locations." + e.getMessage()));
            this.addFieldError(LOCATION, "Unable to load location information");
            throw new ApplicationRuntimeException("Unable to load location information", (Throwable)e);
        }
        return "AJAX_RESULT";
    }

    public String populateStreets() {
        try {
            this.streetList = this.boundaryService.getChildBoundariesByBoundaryId(Long.valueOf(this.locationId));
        }
        catch (Exception e) {
            LOGGER.error((Object)"populateStreets() - Error while loading streets.", (Throwable)e);
            this.addFieldError(LOCATION, "Unable to load street information");
            throw new ApplicationRuntimeException("Unable to load street information", (Throwable)e);
        }
        return STREETS;
    }

    @Action(value="/commonAjax-populateDivisions")
    public String populateDivisions() {
        try {
            Boundary boundary = this.boundaryService.getBoundaryById(Long.valueOf(this.zoneId));
            String cityName = ((Boundary)this.licenseUtils.getAllCity().get(0)).getName();
            if (!boundary.getName().equals(cityName)) {
                this.divisionList = this.boundaryService.getChildBoundariesByBoundaryId(Long.valueOf(this.zoneId));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("populateDivisions() - Error while loading divisions ." + e.getMessage()));
            this.addFieldError(LOCATION, "Unable to load division information");
            throw new ApplicationRuntimeException("Unable to load division information", (Throwable)e);
        }
        return "ward";
    }

    @Action(value="/commonAjax-ajaxPopulateDesignationsByDept")
    public String ajaxPopulateDesignationsByDept() {
        try {
            this.designationList = this.designationService.getAllDesignationByDepartment(Long.valueOf(this.departmentId.intValue()), new Date());
        }
        catch (Exception e) {
            LOGGER.error((Object)("populateDesignationsByDept() - Error while loading divisions ." + e.getMessage()));
            this.addFieldError(LOCATION, "Unable to load Designation information");
            throw new ApplicationRuntimeException("Unable to load Designation information", (Throwable)e);
        }
        return "designation";
    }

    @Action(value="/domain/commonAjax-ajaxPopulateUsersByDesignation")
    public String ajaxPopulateUsersByDesignation() {
        try {
            this.allActiveUsersByGivenDesg = this.eisCommonService.getAllActiveUsersByGivenDesig(Long.valueOf(this.designationId.intValue()));
        }
        catch (Exception e) {
            LOGGER.error((Object)("populateUsersByDept() - Error while loading divisions ." + e.getMessage()));
            this.addFieldError(LOCATION, "Unable to load User information");
            throw new ApplicationRuntimeException("Unable to load User information", (Throwable)e);
        }
        return "users";
    }

    @Action(value="/domain/commonAjax-ajaxPopulateSubCategory")
    public String ajaxPopulateSubCategory() {
        this.subCategoryList = this.licenseSubCategoryService.findAllSubCategoryByCategory(this.categoryId);
        return "subcategory";
    }

    @Action(value="/domain/commonAjax-ajaxPopulateFeeType")
    public String ajaxPopulateFeeType() {
        LicenseSubCategory subCategory = this.licenseSubCategoryService.findById(this.subCategoryId);
        if (subCategory != null && !subCategory.getLicenseSubCategoryDetails().isEmpty()) {
            for (LicenseSubCategoryDetails scd : subCategory.getLicenseSubCategoryDetails()) {
                this.feeTypeList.add(scd.getFeeType());
            }
        }
        return "feeType";
    }

    @Action(value="/domain/commonAjax-ajaxPopulateUom")
    public String ajaxPopulateUom() {
        LicenseSubCategory subCategory = this.licenseSubCategoryService.findById(this.subCategoryId);
        if (subCategory != null && !subCategory.getLicenseSubCategoryDetails().isEmpty()) {
            for (LicenseSubCategoryDetails scd : subCategory.getLicenseSubCategoryDetails()) {
                if (scd.getFeeType().getId() != this.feeTypeId) continue;
                this.uomId = scd.getUom().getId();
                this.uomName = scd.getUom().getName();
                this.rateType = scd.getRateType().toString();
            }
        }
        return "unitOfMeasurement";
    }

    @Action(value="/domain/commonAjax-deleteFee")
    public String deleteFee() {
        FeeMatrixDetail feeMatrixDetail = this.feeMatrixDetailService.findByFeeMatrixDetailId(this.feeMatrixDetailId);
        if (feeMatrixDetail != null) {
            this.feeMatrixDetailService.delete(feeMatrixDetail);
        }
        return "deleteFee";
    }

    @Action(value="/domain/commonAjax-deleteRow")
    public String deleteRow() {
        PenaltyRates penaltyRates = this.penaltyRatesService.findOne(Long.valueOf(this.penaltyRateId));
        if (penaltyRates != null) {
            this.penaltyRatesService.delete(penaltyRates);
        }
        return "deleteRow";
    }

    public List<User> getAllActiveUsersByGivenDesg() {
        return this.allActiveUsersByGivenDesg;
    }

    public void setAllActiveUsersByGivenDesg(List<User> allActiveUsersByGivenDesg) {
        this.allActiveUsersByGivenDesg = allActiveUsersByGivenDesg;
    }

    public int getDivisionId() {
        return this.divisionId;
    }

    public void setDivisionId(int divisionId) {
        this.divisionId = divisionId;
    }

    public int getAreaId() {
        return this.areaId;
    }

    public void setAreaId(int areaId) {
        this.areaId = areaId;
    }

    public int getLocationId() {
        return this.locationId;
    }

    public void setLocationId(int locationId) {
        this.locationId = locationId;
    }

    public int getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(int zoneId) {
        this.zoneId = zoneId;
    }

    public List<Boundary> getLocationList() {
        return this.locationList;
    }

    public void setLocationList(List<Boundary> locationList) {
        this.locationList = locationList;
    }

    public List<Designation> getDesignationList() {
        return this.designationList;
    }

    public void setDesignationList(List<Designation> designationList) {
        this.designationList = designationList;
    }

    public Integer getDepartmentId() {
        return this.departmentId;
    }

    public void setDepartmentId(Integer departmentId) {
        this.departmentId = departmentId;
    }

    public List<Boundary> getAreaList() {
        return this.areaList;
    }

    public void setAreaList(List<Boundary> areaList) {
        this.areaList = areaList;
    }

    public List<Boundary> getStreetList() {
        return this.streetList;
    }

    public void setStreetList(List<Boundary> streetList) {
        this.streetList = streetList;
    }

    public List<Boundary> getDivisionList() {
        return this.divisionList;
    }

    public void setDivisionList(List<Boundary> divisionList) {
        this.divisionList = divisionList;
    }

    public static String getAREA() {
        return AREA;
    }

    public Integer getDesignationId() {
        return this.designationId;
    }

    public void setDesignationId(Integer designationId) {
        this.designationId = designationId;
    }

    public void setLicenseUtils(LicenseUtils licenseUtils) {
        this.licenseUtils = licenseUtils;
    }

    public BoundaryService getBoundaryService() {
        return this.boundaryService;
    }

    public void setBoundaryService(BoundaryService boundaryService) {
        this.boundaryService = boundaryService;
    }

    public DesignationService getDesignationService() {
        return this.designationService;
    }

    public void setDesignationService(DesignationService designationService) {
        this.designationService = designationService;
    }

    public EisCommonService getEisCommonService() {
        return this.eisCommonService;
    }

    public void setEisCommonService(EisCommonService eisCommonService) {
        this.eisCommonService = eisCommonService;
    }

    public LicenseSubCategoryService getLicenseSubCategoryService() {
        return this.licenseSubCategoryService;
    }

    public void setLicenseSubCategoryService(LicenseSubCategoryService licenseSubCategoryService) {
        this.licenseSubCategoryService = licenseSubCategoryService;
    }

    public Long getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public List<LicenseSubCategory> getSubCategoryList() {
        return this.subCategoryList;
    }

    public void setSubCategoryList(List<LicenseSubCategory> subCategoryList) {
        this.subCategoryList = subCategoryList;
    }

    public Long getFeeMatrixDetailId() {
        return this.feeMatrixDetailId;
    }

    public void setFeeMatrixDetailId(Long feeMatrixDetailId) {
        this.feeMatrixDetailId = feeMatrixDetailId;
    }

    public Long getSubCategoryId() {
        return this.subCategoryId;
    }

    public void setSubCategoryId(Long subCategoryId) {
        this.subCategoryId = subCategoryId;
    }

    public Long getFeeTypeId() {
        return this.feeTypeId;
    }

    public void setFeeTypeId(Long feeTypeId) {
        this.feeTypeId = feeTypeId;
    }

    public List<FeeType> getFeeTypeList() {
        return this.feeTypeList;
    }

    public void setFeeTypeList(List<FeeType> feeTypeList) {
        this.feeTypeList = feeTypeList;
    }

    public String getRateType() {
        return this.rateType;
    }

    public void setRateType(String rateType) {
        this.rateType = rateType;
    }

    public Long getUomId() {
        return this.uomId;
    }

    public void setUomId(Long uomId) {
        this.uomId = uomId;
    }

    public String getUomName() {
        return this.uomName;
    }

    public void setUomName(String uomName) {
        this.uomName = uomName;
    }

    public Long getPenaltyRateId() {
        return this.penaltyRateId;
    }

    public void setPenaltyRateId(Long penaltyRateId) {
        this.penaltyRateId = penaltyRateId;
    }
}

