/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.master.category;

import javax.validation.Valid;
import org.egov.tl.entity.LicenseCategory;
import org.egov.tl.service.masters.LicenseCategoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/licensecategory"})
public class UpdateCategoryController {
    private LicenseCategoryService licenseCategoryService;

    @Autowired
    public UpdateCategoryController(LicenseCategoryService licenseCategoryService) {
        this.licenseCategoryService = licenseCategoryService;
    }

    @ModelAttribute
    public LicenseCategory licenseCategoryModel(@PathVariable String code) {
        return this.licenseCategoryService.findCategoryByCode(code);
    }

    @RequestMapping(value={"/update/{code}"}, method={RequestMethod.GET})
    public String categoryUpdateForm(@ModelAttribute @Valid LicenseCategory licenseCategory, Model model) {
        return "licensecategory-update";
    }

    @RequestMapping(value={"/update/{code}"}, method={RequestMethod.POST})
    public String updateCategory(@ModelAttribute @Valid LicenseCategory licenseCategory, BindingResult errors, RedirectAttributes additionalAttr) {
        if (errors.hasErrors()) {
            return "licensecategory-update";
        }
        this.licenseCategoryService.persistCategory(licenseCategory);
        additionalAttr.addFlashAttribute("message", (Object)"msg.success.category.update");
        return "redirect:/licensecategory/view/" + licenseCategory.getCode();
    }
}

