/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller;

import java.util.List;
import org.egov.tl.entity.LicenseAppType;
import org.egov.tl.entity.PenaltyRates;
import org.egov.tl.service.PenaltyRatesService;
import org.egov.tl.web.controller.PenaltyForm;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/penaltyRates"})
public class PenaltyRatesController {
    @Autowired
    private PenaltyRatesService penaltyRatesService;

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String penaltyRatesForm(@ModelAttribute PenaltyForm penaltyForm, Model model) {
        model.addAttribute("licenseAppTypes", (Object)this.penaltyRatesService.findAllLicenseAppType());
        return "penaltyRates-create";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String penaltyRatesCreate(@ModelAttribute PenaltyForm penaltyForm, BindingResult bindingResult, RedirectAttributes redirectAttributes, Model model) {
        LicenseAppType licenseAppType = null;
        licenseAppType = this.penaltyRatesService.findByLicenseAppType(penaltyForm.getLicenseAppType().getId());
        if (bindingResult.hasErrors()) {
            model.addAttribute("licenseAppTypes", (Object)this.penaltyRatesService.findAllLicenseAppType());
            return "penaltyRates-create";
        }
        if (licenseAppType != null && penaltyForm.getPenaltyRatesList() != null && penaltyForm.getPenaltyRatesList().size() > 0) {
            for (PenaltyRates penaltyRates : penaltyForm.getPenaltyRatesList()) {
                penaltyRates.setLicenseAppType(licenseAppType);
                penaltyRates.setFromRange(penaltyRates.getFromRange());
                penaltyRates.setToRange(penaltyRates.getToRange());
                penaltyRates.setRate(penaltyRates.getRate());
                this.penaltyRatesService.create(penaltyRates);
            }
        }
        redirectAttributes.addFlashAttribute("message", (Object)"msg.penaltyRate.created");
        return "penaltyRates-result";
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String search(@ModelAttribute PenaltyForm penaltyForm, BindingResult errors, Model model) {
        if (errors.hasErrors()) {
            return "penaltyRates-result";
        }
        List searchResultList = this.penaltyRatesService.search(penaltyForm.getLicenseAppType().getId());
        if (searchResultList.size() > 0) {
            penaltyForm.setPenaltyRatesList(searchResultList);
        } else {
            penaltyForm.getPenaltyRatesList().clear();
        }
        model.addAttribute("penaltyForm", (Object)penaltyForm);
        return "penaltyRates-result";
    }
}

