/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.infra.web.utils.WebUtils;
import org.egov.tl.service.DCBReportService;
import org.egov.tl.web.controller.DCBReportHelperAdaptor;
import org.egov.tl.web.controller.DCBReportResult;
import org.hibernate.SQLQuery;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/tlreports", "/public/report"})
public class DCBReportController {
    public static final String LICENSE = "license";
    @Autowired
    private DCBReportService dCBReportService;
    @PersistenceContext
    EntityManager entityManager;

    @ModelAttribute(value="dCBReportResult")
    public DCBReportResult dCBReportResultModel() {
        return new DCBReportResult();
    }

    @RequestMapping(value={"/dCBReport/licenseNumberWise"}, method={RequestMethod.GET})
    public String licenseNumberWisesearch(Model model) {
        model.addAttribute("mode", (Object)LICENSE);
        model.addAttribute("reportType", (Object)LICENSE);
        return "dCBReport-search";
    }

    @RequestMapping(value={"/dCBReportList"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public void search(HttpServletRequest request, HttpServletResponse response, Model model) throws IOException {
        List resultList = new ArrayList();
        String licensenumber = "";
        String mode = "";
        String reportType = "";
        if (request.getParameter("mode") != null && !"".equals(request.getParameter("mode"))) {
            mode = request.getParameter("mode");
        }
        if (request.getParameter("reportType") != null && !"".equals(request.getParameter("reportType"))) {
            reportType = request.getParameter("reportType");
        }
        if (request.getParameter("licensenumber") != null && !"".equals(request.getParameter("licensenumber"))) {
            licensenumber = request.getParameter("licensenumber");
        }
        SQLQuery query = this.dCBReportService.prepareQuery(licensenumber, mode, reportType);
        query.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(DCBReportResult.class));
        resultList = query.list();
        String result = null;
        result = "{ \"data\":" + WebUtils.toJSON(resultList, DCBReportResult.class, DCBReportHelperAdaptor.class) + "}";
        response.setContentType("application/json");
        IOUtils.write((String)result, (Writer)response.getWriter());
    }
}

