/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.actions.masters;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.tl.entity.UnitOfMeasurement;
import org.egov.tl.service.masters.UnitOfMeasurementService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

/*
 * Exception performing whole class analysis ignored.
 */
@ParentPackage(value="egov")
@Results(value={@Result(name={"new"}, location="unitOfMeasurement-new.jsp"), @Result(name={"search"}, location="unitOfMeasurement-search.jsp"), @Result(name={"edit"}, location="unitOfMeasurement-edit.jsp")})
public class UnitOfMeasurementAction
extends BaseFormAction {
    private static final long serialVersionUID = -5616536912073613646L;
    private UnitOfMeasurement unitOfMeasurement = new UnitOfMeasurement();
    private Long id;
    public static final String SEARCH = "search";
    public static final String VIEW = "view";
    private Map<Long, String> licenseUomMap;
    @Autowired
    @Qualifier(value="unitOfMeasurementService")
    private UnitOfMeasurementService unitOfMeasurementService;
    private static final Logger LOGGER = Logger.getLogger(UnitOfMeasurementAction.class);
    private String userMode;
    private boolean uomActive;

    public Object getModel() {
        return this.unitOfMeasurement;
    }

    public void prepare() {
        if (this.userMode != null && !this.userMode.isEmpty() && (this.userMode.equalsIgnoreCase("edit") || this.userMode.equalsIgnoreCase("view"))) {
            this.setLicenseUomMap(UnitOfMeasurementAction.getFormattedUOMMap((List)this.unitOfMeasurementService.findAll()));
        }
        if (this.getId() != null) {
            this.unitOfMeasurement = this.unitOfMeasurementService.findById(this.getId());
        }
    }

    public static Map<Long, String> getFormattedUOMMap(List<UnitOfMeasurement> unitOfMeasurementList) {
        TreeMap<Long, String> uomMap = new TreeMap<Long, String>();
        for (UnitOfMeasurement uom : unitOfMeasurementList) {
            uomMap.put(uom.getId(), uom.getName().concat(" ~ ").concat(uom.getCode()));
        }
        return uomMap;
    }

    @Action(value="/masters/unitOfMeasurement-newform")
    public String newform() {
        if (this.userMode != null && !this.userMode.isEmpty()) {
            if (this.userMode.equalsIgnoreCase("view")) {
                this.userMode = "view";
            } else if (this.userMode.equalsIgnoreCase("edit")) {
                this.userMode = "edit";
            }
        } else {
            this.userMode = "new";
        }
        return "new";
    }

    @Action(value="/masters/unitOfMeasurement-edit")
    public String edit() {
        if (this.userMode.equalsIgnoreCase("edit")) {
            this.userMode = "edit";
        } else if (this.userMode.equalsIgnoreCase("view")) {
            this.userMode = "view";
        }
        return "search";
    }

    @ValidationErrorPage(value="edit")
    @Action(value="/masters/unitOfMeasurement-save")
    public String save() throws NumberFormatException, ApplicationException {
        try {
            if (this.userMode.equalsIgnoreCase("edit")) {
                this.unitOfMeasurement.setActive(this.uomActive);
            }
            this.unitOfMeasurement = this.unitOfMeasurementService.create(this.unitOfMeasurement);
        }
        catch (ValidationException valEx) {
            LOGGER.error((Object)("Exception found while persisting Unit of Measurement: " + valEx.getErrors()));
            throw new ValidationException(valEx.getErrors());
        }
        if (this.userMode.equalsIgnoreCase("new")) {
            this.addActionMessage("'" + this.unitOfMeasurement.getCode() + "' " + this.getText("license.uom.save.success"));
        } else if (this.userMode.equalsIgnoreCase("edit")) {
            this.addActionMessage("'" + this.unitOfMeasurement.getCode() + "' " + this.getText("license.uom.edit.success"));
        }
        this.userMode = "success";
        return "new";
    }

    public String getUserMode() {
        return this.userMode;
    }

    public void setUserMode(String userMode) {
        this.userMode = userMode;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public UnitOfMeasurement getUnitOfMeasurement() {
        return this.unitOfMeasurement;
    }

    public void setUnitOfMeasurement(UnitOfMeasurement unitOfMeasurement) {
        this.unitOfMeasurement = unitOfMeasurement;
    }

    public Map<Long, String> getLicenseUomMap() {
        return this.licenseUomMap;
    }

    public void setLicenseUomMap(Map<Long, String> licenseUomMap) {
        this.licenseUomMap = licenseUomMap;
    }

    public boolean isUomActive() {
        return this.uomActive;
    }

    public void setUomActive(boolean uomActive) {
        this.uomActive = uomActive;
    }
}

